/*
 * Decompiled with CFR 0.152.
 */
package so.trophy;

import so.trophy.TrophyApiClient;
import so.trophy.core.ClientOptions;
import so.trophy.core.Environment;

public final class TrophyApiClientBuilder {
    private ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder();
    private String apiKey = null;
    private Environment environment = Environment.DEFAULT;

    public TrophyApiClientBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public TrophyApiClientBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public TrophyApiClientBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public TrophyApiClientBuilder timeout(int timeout) {
        this.clientOptionsBuilder.timeout(timeout);
        return this;
    }

    public TrophyApiClient build() {
        if (this.apiKey == null) {
            throw new RuntimeException("Please provide apiKey");
        }
        this.clientOptionsBuilder.addHeader("X-API-KEY", this.apiKey);
        this.clientOptionsBuilder.environment(this.environment);
        return new TrophyApiClient(this.clientOptionsBuilder.build());
    }
}

