/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import so.trophy.core.ObjectMappers;
import so.trophy.types.StreakFrequency;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class StreakResponse {
    private final int length;
    private final StreakFrequency frequency;
    private final Map<String, Object> additionalProperties;

    private StreakResponse(int length, StreakFrequency frequency, Map<String, Object> additionalProperties) {
        this.length = length;
        this.frequency = frequency;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="length")
    public int getLength() {
        return this.length;
    }

    @JsonProperty(value="frequency")
    public StreakFrequency getFrequency() {
        return this.frequency;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StreakResponse && this.equalTo((StreakResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StreakResponse other) {
        return this.length == other.length && this.frequency.equals((Object)other.frequency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.length, this.frequency});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LengthStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LengthStage,
    FrequencyStage,
    _FinalStage {
        private int length;
        private StreakFrequency frequency;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(StreakResponse other) {
            this.length(other.getLength());
            this.frequency(other.getFrequency());
            return this;
        }

        @Override
        @JsonSetter(value="length")
        public FrequencyStage length(int length) {
            this.length = length;
            return this;
        }

        @Override
        @JsonSetter(value="frequency")
        public _FinalStage frequency(@NotNull StreakFrequency frequency) {
            this.frequency = Objects.requireNonNull(frequency, "frequency must not be null");
            return this;
        }

        @Override
        public StreakResponse build() {
            return new StreakResponse(this.length, this.frequency, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public StreakResponse build();
    }

    public static interface FrequencyStage {
        public _FinalStage frequency(@NotNull StreakFrequency var1);
    }

    public static interface LengthStage {
        public FrequencyStage length(int var1);

        public Builder from(StreakResponse var1);
    }
}

