/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import so.trophy.core.ObjectMappers;
import so.trophy.types.IUpdatedUser;
import so.trophy.types.IUpsertedUser;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class User
implements IUpsertedUser,
IUpdatedUser {
    private final String id;
    private final Optional<String> email;
    private final Optional<String> name;
    private final Optional<String> tz;
    private final Optional<Boolean> subscribeToEmails;
    private final Optional<Boolean> control;
    private final Optional<OffsetDateTime> created;
    private final Optional<OffsetDateTime> updated;
    private final Map<String, Object> additionalProperties;

    private User(String id, Optional<String> email, Optional<String> name, Optional<String> tz, Optional<Boolean> subscribeToEmails, Optional<Boolean> control, Optional<OffsetDateTime> created, Optional<OffsetDateTime> updated, Map<String, Object> additionalProperties) {
        this.id = id;
        this.email = email;
        this.name = name;
        this.tz = tz;
        this.subscribeToEmails = subscribeToEmails;
        this.control = control;
        this.created = created;
        this.updated = updated;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="email")
    public Optional<String> getEmail() {
        return this.email;
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="tz")
    public Optional<String> getTz() {
        return this.tz;
    }

    @Override
    @JsonProperty(value="subscribeToEmails")
    public Optional<Boolean> getSubscribeToEmails() {
        return this.subscribeToEmails;
    }

    @JsonProperty(value="control")
    public Optional<Boolean> getControl() {
        return this.control;
    }

    @JsonProperty(value="created")
    public Optional<OffsetDateTime> getCreated() {
        return this.created;
    }

    @JsonProperty(value="updated")
    public Optional<OffsetDateTime> getUpdated() {
        return this.updated;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof User && this.equalTo((User)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(User other) {
        return this.id.equals(other.id) && this.email.equals(other.email) && this.name.equals(other.name) && this.tz.equals(other.tz) && this.subscribeToEmails.equals(other.subscribeToEmails) && this.control.equals(other.control) && this.created.equals(other.created) && this.updated.equals(other.updated);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.email, this.name, this.tz, this.subscribeToEmails, this.control, this.created, this.updated);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private String id;
        private Optional<OffsetDateTime> updated = Optional.empty();
        private Optional<OffsetDateTime> created = Optional.empty();
        private Optional<Boolean> control = Optional.empty();
        private Optional<Boolean> subscribeToEmails = Optional.empty();
        private Optional<String> tz = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> email = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(User other) {
            this.id(other.getId());
            this.email(other.getEmail());
            this.name(other.getName());
            this.tz(other.getTz());
            this.subscribeToEmails(other.getSubscribeToEmails());
            this.control(other.getControl());
            this.created(other.getCreated());
            this.updated(other.getUpdated());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage updated(OffsetDateTime updated) {
            this.updated = Optional.ofNullable(updated);
            return this;
        }

        @Override
        @JsonSetter(value="updated", nulls=Nulls.SKIP)
        public _FinalStage updated(Optional<OffsetDateTime> updated) {
            this.updated = updated;
            return this;
        }

        @Override
        public _FinalStage created(OffsetDateTime created) {
            this.created = Optional.ofNullable(created);
            return this;
        }

        @Override
        @JsonSetter(value="created", nulls=Nulls.SKIP)
        public _FinalStage created(Optional<OffsetDateTime> created) {
            this.created = created;
            return this;
        }

        @Override
        public _FinalStage control(Boolean control) {
            this.control = Optional.ofNullable(control);
            return this;
        }

        @Override
        @JsonSetter(value="control", nulls=Nulls.SKIP)
        public _FinalStage control(Optional<Boolean> control) {
            this.control = control;
            return this;
        }

        @Override
        public _FinalStage subscribeToEmails(Boolean subscribeToEmails) {
            this.subscribeToEmails = Optional.ofNullable(subscribeToEmails);
            return this;
        }

        @Override
        @JsonSetter(value="subscribeToEmails", nulls=Nulls.SKIP)
        public _FinalStage subscribeToEmails(Optional<Boolean> subscribeToEmails) {
            this.subscribeToEmails = subscribeToEmails;
            return this;
        }

        @Override
        public _FinalStage tz(String tz) {
            this.tz = Optional.ofNullable(tz);
            return this;
        }

        @Override
        @JsonSetter(value="tz", nulls=Nulls.SKIP)
        public _FinalStage tz(Optional<String> tz) {
            this.tz = tz;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        @Override
        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public _FinalStage email(Optional<String> email) {
            this.email = email;
            return this;
        }

        @Override
        public User build() {
            return new User(this.id, this.email, this.name, this.tz, this.subscribeToEmails, this.control, this.created, this.updated, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public User build();

        public _FinalStage email(Optional<String> var1);

        public _FinalStage email(String var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage tz(Optional<String> var1);

        public _FinalStage tz(String var1);

        public _FinalStage subscribeToEmails(Optional<Boolean> var1);

        public _FinalStage subscribeToEmails(Boolean var1);

        public _FinalStage control(Optional<Boolean> var1);

        public _FinalStage control(Boolean var1);

        public _FinalStage created(Optional<OffsetDateTime> var1);

        public _FinalStage created(OffsetDateTime var1);

        public _FinalStage updated(Optional<OffsetDateTime> var1);

        public _FinalStage updated(OffsetDateTime var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);

        public Builder from(User var1);
    }
}

