/*
 * Decompiled with CFR 0.152.
 */
package so.trophy;

import java.util.function.Supplier;
import so.trophy.TrophyApiClientBuilder;
import so.trophy.core.ClientOptions;
import so.trophy.core.Suppliers;
import so.trophy.resources.achievements.AchievementsClient;
import so.trophy.resources.metrics.MetricsClient;
import so.trophy.resources.users.UsersClient;

public class TrophyApiClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<AchievementsClient> achievementsClient;
    protected final Supplier<MetricsClient> metricsClient;
    protected final Supplier<UsersClient> usersClient;

    public TrophyApiClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.achievementsClient = Suppliers.memoize(() -> new AchievementsClient(clientOptions));
        this.metricsClient = Suppliers.memoize(() -> new MetricsClient(clientOptions));
        this.usersClient = Suppliers.memoize(() -> new UsersClient(clientOptions));
    }

    public AchievementsClient achievements() {
        return this.achievementsClient.get();
    }

    public MetricsClient metrics() {
        return this.metricsClient.get();
    }

    public UsersClient users() {
        return this.usersClient.get();
    }

    public static TrophyApiClientBuilder builder() {
        return new TrophyApiClientBuilder();
    }
}

