/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.resources.metrics;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import so.trophy.core.ClientOptions;
import so.trophy.core.MediaTypes;
import so.trophy.core.ObjectMappers;
import so.trophy.core.RequestOptions;
import so.trophy.core.TrophyApiApiException;
import so.trophy.core.TrophyApiException;
import so.trophy.errors.BadRequestError;
import so.trophy.errors.UnauthorizedError;
import so.trophy.errors.UnprocessableEntityError;
import so.trophy.resources.metrics.requests.MetricsEventRequest;
import so.trophy.types.ErrorBody;
import so.trophy.types.EventResponse;

public class MetricsClient {
    protected final ClientOptions clientOptions;

    public MetricsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public EventResponse event(String key, MetricsEventRequest request) {
        return this.event(key, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EventResponse event(String key, MetricsEventRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("metrics").addPathSegment(key).addPathSegments("event").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new TrophyApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                EventResponse eventResponse = (EventResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), EventResponse.class);
                return eventResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 422: {
                        throw new UnprocessableEntityError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                }
                throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new TrophyApiException("Network error executing HTTP request", e);
        }
    }
}

