/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import so.trophy.core.ObjectMappers;
import so.trophy.types.EventResponseMetricsItem;
import so.trophy.types.IncrementMetricStreakResponse;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EventResponse {
    private final String eventId;
    private final String metricId;
    private final double total;
    private final Optional<List<EventResponseMetricsItem>> achievements;
    private final Optional<IncrementMetricStreakResponse> currentStreak;
    private final Map<String, Object> additionalProperties;

    private EventResponse(String eventId, String metricId, double total, Optional<List<EventResponseMetricsItem>> achievements, Optional<IncrementMetricStreakResponse> currentStreak, Map<String, Object> additionalProperties) {
        this.eventId = eventId;
        this.metricId = metricId;
        this.total = total;
        this.achievements = achievements;
        this.currentStreak = currentStreak;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="eventId")
    public String getEventId() {
        return this.eventId;
    }

    @JsonProperty(value="metricId")
    public String getMetricId() {
        return this.metricId;
    }

    @JsonProperty(value="total")
    public double getTotal() {
        return this.total;
    }

    @JsonProperty(value="achievements")
    public Optional<List<EventResponseMetricsItem>> getAchievements() {
        return this.achievements;
    }

    @JsonProperty(value="currentStreak")
    public Optional<IncrementMetricStreakResponse> getCurrentStreak() {
        return this.currentStreak;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EventResponse && this.equalTo((EventResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EventResponse other) {
        return this.eventId.equals(other.eventId) && this.metricId.equals(other.metricId) && this.total == other.total && this.achievements.equals(other.achievements) && this.currentStreak.equals(other.currentStreak);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.metricId, this.total, this.achievements, this.currentStreak);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EventIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EventIdStage,
    MetricIdStage,
    TotalStage,
    _FinalStage {
        private String eventId;
        private String metricId;
        private double total;
        private Optional<IncrementMetricStreakResponse> currentStreak = Optional.empty();
        private Optional<List<EventResponseMetricsItem>> achievements = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(EventResponse other) {
            this.eventId(other.getEventId());
            this.metricId(other.getMetricId());
            this.total(other.getTotal());
            this.achievements(other.getAchievements());
            this.currentStreak(other.getCurrentStreak());
            return this;
        }

        @Override
        @JsonSetter(value="eventId")
        public MetricIdStage eventId(@NotNull String eventId) {
            this.eventId = Objects.requireNonNull(eventId, "eventId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="metricId")
        public TotalStage metricId(@NotNull String metricId) {
            this.metricId = Objects.requireNonNull(metricId, "metricId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="total")
        public _FinalStage total(double total) {
            this.total = total;
            return this;
        }

        @Override
        public _FinalStage currentStreak(IncrementMetricStreakResponse currentStreak) {
            this.currentStreak = Optional.ofNullable(currentStreak);
            return this;
        }

        @Override
        @JsonSetter(value="currentStreak", nulls=Nulls.SKIP)
        public _FinalStage currentStreak(Optional<IncrementMetricStreakResponse> currentStreak) {
            this.currentStreak = currentStreak;
            return this;
        }

        @Override
        public _FinalStage achievements(List<EventResponseMetricsItem> achievements) {
            this.achievements = Optional.ofNullable(achievements);
            return this;
        }

        @Override
        @JsonSetter(value="achievements", nulls=Nulls.SKIP)
        public _FinalStage achievements(Optional<List<EventResponseMetricsItem>> achievements) {
            this.achievements = achievements;
            return this;
        }

        @Override
        public EventResponse build() {
            return new EventResponse(this.eventId, this.metricId, this.total, this.achievements, this.currentStreak, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public EventResponse build();

        public _FinalStage achievements(Optional<List<EventResponseMetricsItem>> var1);

        public _FinalStage achievements(List<EventResponseMetricsItem> var1);

        public _FinalStage currentStreak(Optional<IncrementMetricStreakResponse> var1);

        public _FinalStage currentStreak(IncrementMetricStreakResponse var1);
    }

    public static interface TotalStage {
        public _FinalStage total(double var1);
    }

    public static interface MetricIdStage {
        public TotalStage metricId(@NotNull String var1);
    }

    public static interface EventIdStage {
        public MetricIdStage eventId(@NotNull String var1);

        public Builder from(EventResponse var1);
    }
}

