/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import so.trophy.core.ObjectMappers;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OneOffAchievementResponse {
    private final String id;
    private final Optional<String> name;
    private final Optional<String> badgeUrl;
    private final Optional<String> key;
    private final Optional<OffsetDateTime> achievedAt;
    private final Map<String, Object> additionalProperties;

    private OneOffAchievementResponse(String id, Optional<String> name, Optional<String> badgeUrl, Optional<String> key, Optional<OffsetDateTime> achievedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.badgeUrl = badgeUrl;
        this.key = key;
        this.achievedAt = achievedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="badgeUrl")
    public Optional<String> getBadgeUrl() {
        return this.badgeUrl;
    }

    @JsonProperty(value="key")
    public Optional<String> getKey() {
        return this.key;
    }

    @JsonProperty(value="achievedAt")
    public Optional<OffsetDateTime> getAchievedAt() {
        return this.achievedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OneOffAchievementResponse && this.equalTo((OneOffAchievementResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OneOffAchievementResponse other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.badgeUrl.equals(other.badgeUrl) && this.key.equals(other.key) && this.achievedAt.equals(other.achievedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.badgeUrl, this.key, this.achievedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private String id;
        private Optional<OffsetDateTime> achievedAt = Optional.empty();
        private Optional<String> key = Optional.empty();
        private Optional<String> badgeUrl = Optional.empty();
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OneOffAchievementResponse other) {
            this.id(other.getId());
            this.name(other.getName());
            this.badgeUrl(other.getBadgeUrl());
            this.key(other.getKey());
            this.achievedAt(other.getAchievedAt());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage achievedAt(OffsetDateTime achievedAt) {
            this.achievedAt = Optional.ofNullable(achievedAt);
            return this;
        }

        @Override
        @JsonSetter(value="achievedAt", nulls=Nulls.SKIP)
        public _FinalStage achievedAt(Optional<OffsetDateTime> achievedAt) {
            this.achievedAt = achievedAt;
            return this;
        }

        @Override
        public _FinalStage key(String key) {
            this.key = Optional.ofNullable(key);
            return this;
        }

        @Override
        @JsonSetter(value="key", nulls=Nulls.SKIP)
        public _FinalStage key(Optional<String> key) {
            this.key = key;
            return this;
        }

        @Override
        public _FinalStage badgeUrl(String badgeUrl) {
            this.badgeUrl = Optional.ofNullable(badgeUrl);
            return this;
        }

        @Override
        @JsonSetter(value="badgeUrl", nulls=Nulls.SKIP)
        public _FinalStage badgeUrl(Optional<String> badgeUrl) {
            this.badgeUrl = badgeUrl;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public OneOffAchievementResponse build() {
            return new OneOffAchievementResponse(this.id, this.name, this.badgeUrl, this.key, this.achievedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OneOffAchievementResponse build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage badgeUrl(Optional<String> var1);

        public _FinalStage badgeUrl(String var1);

        public _FinalStage key(Optional<String> var1);

        public _FinalStage key(String var1);

        public _FinalStage achievedAt(Optional<OffsetDateTime> var1);

        public _FinalStage achievedAt(OffsetDateTime var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);

        public Builder from(OneOffAchievementResponse var1);
    }
}

