/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import so.trophy.core.ObjectMappers;
import so.trophy.types.IBaseStreakResponse;
import so.trophy.types.StreakFrequency;
import so.trophy.types.StreakResponseStreakHistoryItem;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class StreakResponse
implements IBaseStreakResponse {
    private final int length;
    private final StreakFrequency frequency;
    private final Optional<String> started;
    private final Optional<String> periodStart;
    private final Optional<String> periodEnd;
    private final Optional<String> expires;
    private final Optional<List<StreakResponseStreakHistoryItem>> streakHistory;
    private final Map<String, Object> additionalProperties;

    private StreakResponse(int length, StreakFrequency frequency, Optional<String> started, Optional<String> periodStart, Optional<String> periodEnd, Optional<String> expires, Optional<List<StreakResponseStreakHistoryItem>> streakHistory, Map<String, Object> additionalProperties) {
        this.length = length;
        this.frequency = frequency;
        this.started = started;
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.expires = expires;
        this.streakHistory = streakHistory;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="length")
    public int getLength() {
        return this.length;
    }

    @Override
    @JsonProperty(value="frequency")
    public StreakFrequency getFrequency() {
        return this.frequency;
    }

    @Override
    @JsonProperty(value="started")
    public Optional<String> getStarted() {
        return this.started;
    }

    @Override
    @JsonProperty(value="periodStart")
    public Optional<String> getPeriodStart() {
        return this.periodStart;
    }

    @Override
    @JsonProperty(value="periodEnd")
    public Optional<String> getPeriodEnd() {
        return this.periodEnd;
    }

    @Override
    @JsonProperty(value="expires")
    public Optional<String> getExpires() {
        return this.expires;
    }

    @JsonProperty(value="streakHistory")
    public Optional<List<StreakResponseStreakHistoryItem>> getStreakHistory() {
        return this.streakHistory;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StreakResponse && this.equalTo((StreakResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StreakResponse other) {
        return this.length == other.length && this.frequency.equals((Object)other.frequency) && this.started.equals(other.started) && this.periodStart.equals(other.periodStart) && this.periodEnd.equals(other.periodEnd) && this.expires.equals(other.expires) && this.streakHistory.equals(other.streakHistory);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.length, this.frequency, this.started, this.periodStart, this.periodEnd, this.expires, this.streakHistory});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LengthStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LengthStage,
    FrequencyStage,
    _FinalStage {
        private int length;
        private StreakFrequency frequency;
        private Optional<List<StreakResponseStreakHistoryItem>> streakHistory = Optional.empty();
        private Optional<String> expires = Optional.empty();
        private Optional<String> periodEnd = Optional.empty();
        private Optional<String> periodStart = Optional.empty();
        private Optional<String> started = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(StreakResponse other) {
            this.length(other.getLength());
            this.frequency(other.getFrequency());
            this.started(other.getStarted());
            this.periodStart(other.getPeriodStart());
            this.periodEnd(other.getPeriodEnd());
            this.expires(other.getExpires());
            this.streakHistory(other.getStreakHistory());
            return this;
        }

        @Override
        @JsonSetter(value="length")
        public FrequencyStage length(int length) {
            this.length = length;
            return this;
        }

        @Override
        @JsonSetter(value="frequency")
        public _FinalStage frequency(@NotNull StreakFrequency frequency) {
            this.frequency = Objects.requireNonNull(frequency, "frequency must not be null");
            return this;
        }

        @Override
        public _FinalStage streakHistory(List<StreakResponseStreakHistoryItem> streakHistory) {
            this.streakHistory = Optional.ofNullable(streakHistory);
            return this;
        }

        @Override
        @JsonSetter(value="streakHistory", nulls=Nulls.SKIP)
        public _FinalStage streakHistory(Optional<List<StreakResponseStreakHistoryItem>> streakHistory) {
            this.streakHistory = streakHistory;
            return this;
        }

        @Override
        public _FinalStage expires(String expires) {
            this.expires = Optional.ofNullable(expires);
            return this;
        }

        @Override
        @JsonSetter(value="expires", nulls=Nulls.SKIP)
        public _FinalStage expires(Optional<String> expires) {
            this.expires = expires;
            return this;
        }

        @Override
        public _FinalStage periodEnd(String periodEnd) {
            this.periodEnd = Optional.ofNullable(periodEnd);
            return this;
        }

        @Override
        @JsonSetter(value="periodEnd", nulls=Nulls.SKIP)
        public _FinalStage periodEnd(Optional<String> periodEnd) {
            this.periodEnd = periodEnd;
            return this;
        }

        @Override
        public _FinalStage periodStart(String periodStart) {
            this.periodStart = Optional.ofNullable(periodStart);
            return this;
        }

        @Override
        @JsonSetter(value="periodStart", nulls=Nulls.SKIP)
        public _FinalStage periodStart(Optional<String> periodStart) {
            this.periodStart = periodStart;
            return this;
        }

        @Override
        public _FinalStage started(String started) {
            this.started = Optional.ofNullable(started);
            return this;
        }

        @Override
        @JsonSetter(value="started", nulls=Nulls.SKIP)
        public _FinalStage started(Optional<String> started) {
            this.started = started;
            return this;
        }

        @Override
        public StreakResponse build() {
            return new StreakResponse(this.length, this.frequency, this.started, this.periodStart, this.periodEnd, this.expires, this.streakHistory, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public StreakResponse build();

        public _FinalStage started(Optional<String> var1);

        public _FinalStage started(String var1);

        public _FinalStage periodStart(Optional<String> var1);

        public _FinalStage periodStart(String var1);

        public _FinalStage periodEnd(Optional<String> var1);

        public _FinalStage periodEnd(String var1);

        public _FinalStage expires(Optional<String> var1);

        public _FinalStage expires(String var1);

        public _FinalStage streakHistory(Optional<List<StreakResponseStreakHistoryItem>> var1);

        public _FinalStage streakHistory(List<StreakResponseStreakHistoryItem> var1);
    }

    public static interface FrequencyStage {
        public _FinalStage frequency(@NotNull StreakFrequency var1);
    }

    public static interface LengthStage {
        public FrequencyStage length(int var1);

        public Builder from(StreakResponse var1);
    }
}

