/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import so.trophy.core.ObjectMappers;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class StreakResponseStreakHistoryItem {
    private final String periodStart;
    private final String periodEnd;
    private final int length;
    private final Map<String, Object> additionalProperties;

    private StreakResponseStreakHistoryItem(String periodStart, String periodEnd, int length, Map<String, Object> additionalProperties) {
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.length = length;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="periodStart")
    public String getPeriodStart() {
        return this.periodStart;
    }

    @JsonProperty(value="periodEnd")
    public String getPeriodEnd() {
        return this.periodEnd;
    }

    @JsonProperty(value="length")
    public int getLength() {
        return this.length;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StreakResponseStreakHistoryItem && this.equalTo((StreakResponseStreakHistoryItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StreakResponseStreakHistoryItem other) {
        return this.periodStart.equals(other.periodStart) && this.periodEnd.equals(other.periodEnd) && this.length == other.length;
    }

    public int hashCode() {
        return Objects.hash(this.periodStart, this.periodEnd, this.length);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PeriodStartStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PeriodStartStage,
    PeriodEndStage,
    LengthStage,
    _FinalStage {
        private String periodStart;
        private String periodEnd;
        private int length;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(StreakResponseStreakHistoryItem other) {
            this.periodStart(other.getPeriodStart());
            this.periodEnd(other.getPeriodEnd());
            this.length(other.getLength());
            return this;
        }

        @Override
        @JsonSetter(value="periodStart")
        public PeriodEndStage periodStart(@NotNull String periodStart) {
            this.periodStart = Objects.requireNonNull(periodStart, "periodStart must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="periodEnd")
        public LengthStage periodEnd(@NotNull String periodEnd) {
            this.periodEnd = Objects.requireNonNull(periodEnd, "periodEnd must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="length")
        public _FinalStage length(int length) {
            this.length = length;
            return this;
        }

        @Override
        public StreakResponseStreakHistoryItem build() {
            return new StreakResponseStreakHistoryItem(this.periodStart, this.periodEnd, this.length, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public StreakResponseStreakHistoryItem build();
    }

    public static interface LengthStage {
        public _FinalStage length(int var1);
    }

    public static interface PeriodEndStage {
        public LengthStage periodEnd(@NotNull String var1);
    }

    public static interface PeriodStartStage {
        public PeriodEndStage periodStart(@NotNull String var1);

        public Builder from(StreakResponseStreakHistoryItem var1);
    }
}

