/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.core;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import so.trophy.core.Environment;
import so.trophy.core.RequestOptions;
import so.trophy.core.RetryInterceptor;

public final class ClientOptions {
    private final Environment environment;
    private final Map<String, String> headers;
    private final Map<String, Supplier<String>> headerSuppliers;
    private final OkHttpClient httpClient;
    private final int timeout;

    private ClientOptions(Environment environment, Map<String, String> headers, Map<String, Supplier<String>> headerSuppliers, OkHttpClient httpClient, int timeout) {
        this.environment = environment;
        this.headers = new HashMap<String, String>();
        this.headers.putAll(headers);
        this.headers.putAll((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("X-Fern-Language", "JAVA");
                this.put("X-Fern-SDK-Name", "com.trophy.fern:api-sdk");
                this.put("X-Fern-SDK-Version", "0.0.1111");
            }
        });
        this.headerSuppliers = headerSuppliers;
        this.httpClient = httpClient;
        this.timeout = timeout;
    }

    public Environment environment() {
        return this.environment;
    }

    public Map<String, String> headers(RequestOptions requestOptions) {
        HashMap<String, String> values = new HashMap<String, String>(this.headers);
        this.headerSuppliers.forEach((key, supplier) -> values.put((String)key, (String)supplier.get()));
        if (requestOptions != null) {
            values.putAll(requestOptions.getHeaders());
        }
        return values;
    }

    public OkHttpClient httpClient() {
        return this.httpClient;
    }

    public OkHttpClient httpClientWithTimeout(RequestOptions requestOptions) {
        if (requestOptions == null) {
            return this.httpClient;
        }
        return this.httpClient.newBuilder().callTimeout((long)requestOptions.getTimeout().get().intValue(), requestOptions.getTimeoutTimeUnit()).connectTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.SECONDS).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Environment environment;
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, Supplier<String>> headerSuppliers = new HashMap<String, Supplier<String>>();
        private int timeout = 60;

        public Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder addHeader(String key, Supplier<String> value) {
            this.headerSuppliers.put(key, value);
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public ClientOptions build() {
            OkHttpClient okhttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new RetryInterceptor(3)).callTimeout((long)this.timeout, TimeUnit.SECONDS).build();
            return new ClientOptions(this.environment, this.headers, this.headerSuppliers, okhttpClient, this.timeout);
        }
    }
}

