/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public final class RequestOptions {
    private final String apiKey;
    private final Optional<Integer> timeout;
    private final TimeUnit timeoutTimeUnit;

    private RequestOptions(String apiKey, Optional<Integer> timeout, TimeUnit timeoutTimeUnit) {
        this.apiKey = apiKey;
        this.timeout = timeout;
        this.timeoutTimeUnit = timeoutTimeUnit;
    }

    public Optional<Integer> getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeoutTimeUnit() {
        return this.timeoutTimeUnit;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.apiKey != null) {
            headers.put("X-API-KEY", this.apiKey);
        }
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String apiKey = null;
        private Optional<Integer> timeout = Optional.empty();
        private TimeUnit timeoutTimeUnit = TimeUnit.SECONDS;

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = Optional.of(timeout);
            return this;
        }

        public Builder timeout(Integer timeout, TimeUnit timeoutTimeUnit) {
            this.timeout = Optional.of(timeout);
            this.timeoutTimeUnit = timeoutTimeUnit;
            return this;
        }

        public RequestOptions build() {
            return new RequestOptions(this.apiKey, this.timeout, this.timeoutTimeUnit);
        }
    }
}

