/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.resources.users;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import so.trophy.core.ClientOptions;
import so.trophy.core.MediaTypes;
import so.trophy.core.ObjectMappers;
import so.trophy.core.RequestOptions;
import so.trophy.core.TrophyApiApiException;
import so.trophy.core.TrophyApiException;
import so.trophy.errors.BadRequestError;
import so.trophy.errors.NotFoundError;
import so.trophy.errors.UnauthorizedError;
import so.trophy.errors.UnprocessableEntityError;
import so.trophy.resources.users.requests.UsersStreakRequest;
import so.trophy.types.AchievementResponse;
import so.trophy.types.ErrorBody;
import so.trophy.types.MetricResponse;
import so.trophy.types.StreakResponse;
import so.trophy.types.UpdatedUser;
import so.trophy.types.UpsertedUser;
import so.trophy.types.User;

public class UsersClient {
    protected final ClientOptions clientOptions;

    public UsersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public User create(UpsertedUser request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User create(UpsertedUser request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("users").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new TrophyApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                User user = (User)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), User.class);
                return user;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 422: {
                        throw new UnprocessableEntityError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                }
                throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new TrophyApiException("Network error executing HTTP request", e);
        }
    }

    public User get(String id) {
        return this.get(id, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User get(String id, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("users").addPathSegment(id).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                User user = (User)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), User.class);
                return user;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 422: {
                        throw new UnprocessableEntityError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                }
                throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new TrophyApiException("Network error executing HTTP request", e);
        }
    }

    public User update(String id) {
        return this.update(id, UpdatedUser.builder().build());
    }

    public User update(String id, UpdatedUser request) {
        return this.update(id, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User update(String id, UpdatedUser request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("users").addPathSegment(id).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new TrophyApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PATCH", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                User user = (User)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), User.class);
                return user;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 422: {
                        throw new UnprocessableEntityError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                }
                throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new TrophyApiException("Network error executing HTTP request", e);
        }
    }

    public List<MetricResponse> allMetrics(String id) {
        return this.allMetrics(id, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<MetricResponse> allMetrics(String id, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("users").addPathSegment(id).addPathSegments("metrics").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                List list = (List)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), (TypeReference)new TypeReference<List<MetricResponse>>(){});
                return list;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 404: {
                        throw new NotFoundError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 422: {
                        throw new UnprocessableEntityError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                }
                throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new TrophyApiException("Network error executing HTTP request", e);
        }
    }

    public MetricResponse singleMetric(String id, String key) {
        return this.singleMetric(id, key, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetricResponse singleMetric(String id, String key, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("users").addPathSegment(id).addPathSegments("metrics").addPathSegment(key).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                MetricResponse metricResponse = (MetricResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), MetricResponse.class);
                return metricResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 404: {
                        throw new NotFoundError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 422: {
                        throw new UnprocessableEntityError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                }
                throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new TrophyApiException("Network error executing HTTP request", e);
        }
    }

    public List<AchievementResponse> allAchievements(String id) {
        return this.allAchievements(id, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AchievementResponse> allAchievements(String id, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("users").addPathSegment(id).addPathSegments("achievements").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                List list = (List)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), (TypeReference)new TypeReference<List<AchievementResponse>>(){});
                return list;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 404: {
                        throw new NotFoundError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 422: {
                        throw new UnprocessableEntityError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                }
                throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new TrophyApiException("Network error executing HTTP request", e);
        }
    }

    public StreakResponse streak(String id) {
        return this.streak(id, UsersStreakRequest.builder().build());
    }

    public StreakResponse streak(String id, UsersStreakRequest request) {
        return this.streak(id, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StreakResponse streak(String id, UsersStreakRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("users").addPathSegment(id).addPathSegments("streak");
        if (request.getHistoryPeriods().isPresent()) {
            httpUrl.addQueryParameter("historyPeriods", request.getHistoryPeriods().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                StreakResponse streakResponse = (StreakResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), StreakResponse.class);
                return streakResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 404: {
                        throw new NotFoundError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                    case 422: {
                        throw new UnprocessableEntityError((ErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ErrorBody.class));
                    }
                }
                throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new TrophyApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new TrophyApiException("Network error executing HTTP request", e);
        }
    }
}

