/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import so.trophy.core.ObjectMappers;
import so.trophy.types.ApiAchievementResponse;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AchievementCompletionResponse {
    private final String completionId;
    private final ApiAchievementResponse achievement;
    private final Map<String, Object> additionalProperties;

    private AchievementCompletionResponse(String completionId, ApiAchievementResponse achievement, Map<String, Object> additionalProperties) {
        this.completionId = completionId;
        this.achievement = achievement;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="completionId")
    public String getCompletionId() {
        return this.completionId;
    }

    @JsonProperty(value="achievement")
    public ApiAchievementResponse getAchievement() {
        return this.achievement;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AchievementCompletionResponse && this.equalTo((AchievementCompletionResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AchievementCompletionResponse other) {
        return this.completionId.equals(other.completionId) && this.achievement.equals(other.achievement);
    }

    public int hashCode() {
        return Objects.hash(this.completionId, this.achievement);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompletionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CompletionIdStage,
    AchievementStage,
    _FinalStage {
        private String completionId;
        private ApiAchievementResponse achievement;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AchievementCompletionResponse other) {
            this.completionId(other.getCompletionId());
            this.achievement(other.getAchievement());
            return this;
        }

        @Override
        @JsonSetter(value="completionId")
        public AchievementStage completionId(@NotNull String completionId) {
            this.completionId = Objects.requireNonNull(completionId, "completionId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="achievement")
        public _FinalStage achievement(@NotNull ApiAchievementResponse achievement) {
            this.achievement = Objects.requireNonNull(achievement, "achievement must not be null");
            return this;
        }

        @Override
        public AchievementCompletionResponse build() {
            return new AchievementCompletionResponse(this.completionId, this.achievement, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AchievementCompletionResponse build();
    }

    public static interface AchievementStage {
        public _FinalStage achievement(@NotNull ApiAchievementResponse var1);
    }

    public static interface CompletionIdStage {
        public AchievementStage completionId(@NotNull String var1);

        public Builder from(AchievementCompletionResponse var1);
    }
}

