/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Objects;
import so.trophy.core.ObjectMappers;
import so.trophy.types.ApiAchievementResponse;
import so.trophy.types.MetricAchievementResponse;
import so.trophy.types.StreakAchievementResponse;

@JsonDeserialize(using=Deserializer.class)
public final class AchievementResponse {
    private final Object value;
    private final int type;

    private AchievementResponse(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((MetricAchievementResponse)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((StreakAchievementResponse)this.value);
        }
        if (this.type == 2) {
            return visitor.visit((ApiAchievementResponse)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AchievementResponse && this.equalTo((AchievementResponse)other);
    }

    private boolean equalTo(AchievementResponse other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static AchievementResponse of(MetricAchievementResponse value) {
        return new AchievementResponse(value, 0);
    }

    public static AchievementResponse of(StreakAchievementResponse value) {
        return new AchievementResponse(value, 1);
    }

    public static AchievementResponse of(ApiAchievementResponse value) {
        return new AchievementResponse(value, 2);
    }

    static final class Deserializer
    extends StdDeserializer<AchievementResponse> {
        Deserializer() {
            super(AchievementResponse.class);
        }

        public AchievementResponse deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return AchievementResponse.of((MetricAchievementResponse)ObjectMappers.JSON_MAPPER.convertValue(value, MetricAchievementResponse.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return AchievementResponse.of((StreakAchievementResponse)ObjectMappers.JSON_MAPPER.convertValue(value, StreakAchievementResponse.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    try {
                        return AchievementResponse.of((ApiAchievementResponse)ObjectMappers.JSON_MAPPER.convertValue(value, ApiAchievementResponse.class));
                    }
                    catch (IllegalArgumentException illegalArgumentException3) {
                        throw new JsonParseException(p, "Failed to deserialize");
                    }
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(MetricAchievementResponse var1);

        public T visit(StreakAchievementResponse var1);

        public T visit(ApiAchievementResponse var1);
    }
}

