/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import so.trophy.core.ObjectMappers;
import so.trophy.types.IBaseAchievementResponse;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MetricAchievementResponse
implements IBaseAchievementResponse {
    private final String id;
    private final String name;
    private final Optional<String> badgeUrl;
    private final Optional<String> key;
    private final Optional<OffsetDateTime> achievedAt;
    private final String trigger;
    private final String metricId;
    private final double metricValue;
    private final String metricName;
    private final Map<String, Object> additionalProperties;

    private MetricAchievementResponse(String id, String name, Optional<String> badgeUrl, Optional<String> key, Optional<OffsetDateTime> achievedAt, String trigger, String metricId, double metricValue, String metricName, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.badgeUrl = badgeUrl;
        this.key = key;
        this.achievedAt = achievedAt;
        this.trigger = trigger;
        this.metricId = metricId;
        this.metricValue = metricValue;
        this.metricName = metricName;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="badgeUrl")
    public Optional<String> getBadgeUrl() {
        return this.badgeUrl;
    }

    @Override
    @JsonProperty(value="key")
    public Optional<String> getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="achievedAt")
    public Optional<OffsetDateTime> getAchievedAt() {
        return this.achievedAt;
    }

    @JsonProperty(value="trigger")
    public String getTrigger() {
        return this.trigger;
    }

    @JsonProperty(value="metricId")
    public String getMetricId() {
        return this.metricId;
    }

    @JsonProperty(value="metricValue")
    public double getMetricValue() {
        return this.metricValue;
    }

    @JsonProperty(value="metricName")
    public String getMetricName() {
        return this.metricName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MetricAchievementResponse && this.equalTo((MetricAchievementResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MetricAchievementResponse other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.badgeUrl.equals(other.badgeUrl) && this.key.equals(other.key) && this.achievedAt.equals(other.achievedAt) && this.trigger.equals(other.trigger) && this.metricId.equals(other.metricId) && this.metricValue == other.metricValue && this.metricName.equals(other.metricName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.badgeUrl, this.key, this.achievedAt, this.trigger, this.metricId, this.metricValue, this.metricName);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    TriggerStage,
    MetricIdStage,
    MetricValueStage,
    MetricNameStage,
    _FinalStage {
        private String id;
        private String name;
        private String trigger;
        private String metricId;
        private double metricValue;
        private String metricName;
        private Optional<OffsetDateTime> achievedAt = Optional.empty();
        private Optional<String> key = Optional.empty();
        private Optional<String> badgeUrl = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(MetricAchievementResponse other) {
            this.id(other.getId());
            this.name(other.getName());
            this.badgeUrl(other.getBadgeUrl());
            this.key(other.getKey());
            this.achievedAt(other.getAchievedAt());
            this.trigger(other.getTrigger());
            this.metricId(other.getMetricId());
            this.metricValue(other.getMetricValue());
            this.metricName(other.getMetricName());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public TriggerStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="trigger")
        public MetricIdStage trigger(@NotNull String trigger) {
            this.trigger = Objects.requireNonNull(trigger, "trigger must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="metricId")
        public MetricValueStage metricId(@NotNull String metricId) {
            this.metricId = Objects.requireNonNull(metricId, "metricId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="metricValue")
        public MetricNameStage metricValue(double metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        @Override
        @JsonSetter(value="metricName")
        public _FinalStage metricName(@NotNull String metricName) {
            this.metricName = Objects.requireNonNull(metricName, "metricName must not be null");
            return this;
        }

        @Override
        public _FinalStage achievedAt(OffsetDateTime achievedAt) {
            this.achievedAt = Optional.ofNullable(achievedAt);
            return this;
        }

        @Override
        @JsonSetter(value="achievedAt", nulls=Nulls.SKIP)
        public _FinalStage achievedAt(Optional<OffsetDateTime> achievedAt) {
            this.achievedAt = achievedAt;
            return this;
        }

        @Override
        public _FinalStage key(String key) {
            this.key = Optional.ofNullable(key);
            return this;
        }

        @Override
        @JsonSetter(value="key", nulls=Nulls.SKIP)
        public _FinalStage key(Optional<String> key) {
            this.key = key;
            return this;
        }

        @Override
        public _FinalStage badgeUrl(String badgeUrl) {
            this.badgeUrl = Optional.ofNullable(badgeUrl);
            return this;
        }

        @Override
        @JsonSetter(value="badgeUrl", nulls=Nulls.SKIP)
        public _FinalStage badgeUrl(Optional<String> badgeUrl) {
            this.badgeUrl = badgeUrl;
            return this;
        }

        @Override
        public MetricAchievementResponse build() {
            return new MetricAchievementResponse(this.id, this.name, this.badgeUrl, this.key, this.achievedAt, this.trigger, this.metricId, this.metricValue, this.metricName, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public MetricAchievementResponse build();

        public _FinalStage badgeUrl(Optional<String> var1);

        public _FinalStage badgeUrl(String var1);

        public _FinalStage key(Optional<String> var1);

        public _FinalStage key(String var1);

        public _FinalStage achievedAt(Optional<OffsetDateTime> var1);

        public _FinalStage achievedAt(OffsetDateTime var1);
    }

    public static interface MetricNameStage {
        public _FinalStage metricName(@NotNull String var1);
    }

    public static interface MetricValueStage {
        public MetricNameStage metricValue(double var1);
    }

    public static interface MetricIdStage {
        public MetricValueStage metricId(@NotNull String var1);
    }

    public static interface TriggerStage {
        public MetricIdStage trigger(@NotNull String var1);
    }

    public static interface NameStage {
        public TriggerStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(MetricAchievementResponse var1);
    }
}

