/*
 * Decompiled with CFR 0.152.
 */
package so.trophy.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import so.trophy.core.ObjectMappers;
import so.trophy.types.MetricAchievementResponse;
import so.trophy.types.MetricStatus;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MetricResponse {
    private final String id;
    private final String key;
    private final String name;
    private final MetricStatus status;
    private final double current;
    private final List<MetricAchievementResponse> achievements;
    private final Map<String, Object> additionalProperties;

    private MetricResponse(String id, String key, String name, MetricStatus status, double current, List<MetricAchievementResponse> achievements, Map<String, Object> additionalProperties) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.status = status;
        this.current = current;
        this.achievements = achievements;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="status")
    public MetricStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="current")
    public double getCurrent() {
        return this.current;
    }

    @JsonProperty(value="achievements")
    public List<MetricAchievementResponse> getAchievements() {
        return this.achievements;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MetricResponse && this.equalTo((MetricResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MetricResponse other) {
        return this.id.equals(other.id) && this.key.equals(other.key) && this.name.equals(other.name) && this.status.equals((Object)other.status) && this.current == other.current && this.achievements.equals(other.achievements);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.key, this.name, this.status, this.current, this.achievements});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    KeyStage,
    NameStage,
    StatusStage,
    CurrentStage,
    _FinalStage {
        private String id;
        private String key;
        private String name;
        private MetricStatus status;
        private double current;
        private List<MetricAchievementResponse> achievements = new ArrayList<MetricAchievementResponse>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(MetricResponse other) {
            this.id(other.getId());
            this.key(other.getKey());
            this.name(other.getName());
            this.status(other.getStatus());
            this.current(other.getCurrent());
            this.achievements(other.getAchievements());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public KeyStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="key")
        public NameStage key(@NotNull String key) {
            this.key = Objects.requireNonNull(key, "key must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public StatusStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public CurrentStage status(@NotNull MetricStatus status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="current")
        public _FinalStage current(double current) {
            this.current = current;
            return this;
        }

        @Override
        public _FinalStage addAllAchievements(List<MetricAchievementResponse> achievements) {
            this.achievements.addAll(achievements);
            return this;
        }

        @Override
        public _FinalStage addAchievements(MetricAchievementResponse achievements) {
            this.achievements.add(achievements);
            return this;
        }

        @Override
        @JsonSetter(value="achievements", nulls=Nulls.SKIP)
        public _FinalStage achievements(List<MetricAchievementResponse> achievements) {
            this.achievements.clear();
            this.achievements.addAll(achievements);
            return this;
        }

        @Override
        public MetricResponse build() {
            return new MetricResponse(this.id, this.key, this.name, this.status, this.current, this.achievements, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public MetricResponse build();

        public _FinalStage achievements(List<MetricAchievementResponse> var1);

        public _FinalStage addAchievements(MetricAchievementResponse var1);

        public _FinalStage addAllAchievements(List<MetricAchievementResponse> var1);
    }

    public static interface CurrentStage {
        public _FinalStage current(double var1);
    }

    public static interface StatusStage {
        public CurrentStage status(@NotNull MetricStatus var1);
    }

    public static interface NameStage {
        public StatusStage name(@NotNull String var1);
    }

    public static interface KeyStage {
        public NameStage key(@NotNull String var1);
    }

    public static interface IdStage {
        public KeyStage id(@NotNull String var1);

        public Builder from(MetricResponse var1);
    }
}

