/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.sessionize.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Locale;

public enum Status {
    ACCEPTED("Accepted"),
    ACCEPTED_QUEUE("Accepted_Queue"),
    NOMINATED("Nominated"),
    DECLINE_QUEUE("Decline_Queue"),
    DECLINED("Declined");

    private String value;

    private Status(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static Status fromValue(String value) {
        for (Status b : Status.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format(Locale.ROOT, "%s=%s", prefix, this.toString());
    }
}

