/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.Net;
import tech.deplant.java4ever.binding.Tvm;
import tech.deplant.java4ever.framework.Address;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.abi.ContractAbi;
import tech.deplant.java4ever.framework.crypto.Credentials;

public record Account(String id, int accType, String balance, String boc, String data, String dataHash, String code, String codeHash, String initCodeHash, long last_paid) {
    private static System.Logger logger = System.getLogger(Account.class.getName());

    public static Account ofAddress(Sdk sdk, Address address) throws EverSdkException {
        HashMap<String, GraphQLFilter.In> filter = new HashMap<String, GraphQLFilter.In>();
        filter.put("id", new GraphQLFilter.In(new String[]{address.makeAddrStd()}));
        Net.ResultOfQueryCollection result = Net.queryCollection((Context)sdk.context(), (String)"accounts", filter, (String)"id acc_type balance boc data data_hash code code_hash init_code_hash last_paid", null, null);
        if (result.result().length > 0) {
            return sdk.convertMap(result.result()[0], Account.class);
        }
        return new Account(address.makeAddrStd(), 0, "0x00", null, null, null, null, null, null, 0L);
    }

    public static List<Account> ofAddressList(Sdk sdk, Address ... addresses) throws EverSdkException {
        HashMap<String, GraphQLFilter.In> filter = new HashMap<String, GraphQLFilter.In>();
        filter.put("id", new GraphQLFilter.In((String[])Arrays.stream(addresses).map(Address::makeAddrStd).toArray(String[]::new)));
        return Arrays.stream(Net.queryCollection((Context)sdk.context(), (String)"accounts", filter, (String)"id acc_type balance boc data data_hash code code_hash init_code_hash last_paid", null, null).result()).map(obj -> sdk.convertMap((Map<String, Object>)obj, Account.class)).toList();
    }

    public Map<String, Object> runGetter(Sdk sdk, ContractAbi abi, String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader, Credentials credentials) throws EverSdkException {
        Abi.ResultOfEncodeMessage msg = Abi.encodeMessage((Context)sdk.context(), (Abi.ABI)abi.ABI(), (String)this.id(), null, (Abi.CallSet)new Abi.CallSet(functionName, null, abi.convertFunctionInputs(functionName, functionInputs)), (Abi.Signer)credentials.signer(), null);
        return Optional.ofNullable(Tvm.runTvm((Context)sdk.context(), (String)msg.message(), (String)this.boc(), null, (Abi.ABI)abi.ABI(), null, (Boolean)false).decoded().output()).orElse(new HashMap());
    }

    public Tvm.ResultOfRunExecutor runLocal(Sdk sdk, ContractAbi abi, String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader, Credentials credentials, Tvm.ExecutionOptions options) throws EverSdkException {
        Abi.ResultOfEncodeMessage msg = Abi.encodeMessage((Context)sdk.context(), (Abi.ABI)abi.ABI(), (String)this.id(), null, (Abi.CallSet)new Abi.CallSet(functionName, null, abi.convertFunctionInputs(functionName, functionInputs)), (Abi.Signer)credentials.signer(), null);
        return Tvm.runExecutor((Context)sdk.context(), (String)msg.message(), (Tvm.AccountForExecutor)new Tvm.AccountForExecutor.Account(this.boc(), Boolean.valueOf(true)), (Tvm.ExecutionOptions)options, (Abi.ABI)abi.ABI(), (Boolean)false, null, (Boolean)true);
    }

    public Boolean isActive() {
        return 1 == this.accType;
    }

    public String tvmPubkey(Sdk sdk, ContractAbi abi) throws EverSdkException {
        return Abi.decodeInitialData((Context)sdk.context(), (Abi.ABI)abi.ABI(), (String)this.data(), (Boolean)false).initialPubkey();
    }

    public static interface GraphQLFilter {

        public record Lt(String lt) implements GraphQLFilter
        {
        }

        public record Gt(String gt) implements GraphQLFilter
        {
        }

        public record Eq(Integer eq) implements GraphQLFilter
        {
        }

        public record In(String[] in) implements GraphQLFilter
        {
        }
    }
}

