/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import java.math.BigInteger;
import java.util.Map;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Data;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.crypto.Credentials;
import tech.deplant.java4ever.framework.template.ContractTemplate;

public record Address(int wid, BigInteger value) {
    public static final Address ZERO = new Address(0, BigInteger.ZERO);

    public Address(String address) {
        this(Integer.parseInt(address.split(":")[0]), new BigInteger(address.split(":")[1], 16));
    }

    public Address(BigInteger value) {
        this(0, value);
    }

    public static Address ofNullable(Object nullableObject) {
        return null == nullableObject ? ZERO : new Address(nullableObject.toString());
    }

    public static Address ofFutureDeploy(Sdk sdk, ContractTemplate template, int workchainId, Map<String, Object> initialData, Credentials credentials) throws EverSdkException {
        return new Address(Abi.encodeMessage((Context)sdk.context(), (Abi.ABI)template.abi().ABI(), null, (Abi.DeploySet)new Abi.DeploySet(template.tvc().base64String(), (Number)workchainId, initialData, credentials.publicKey()), null, (Abi.Signer)credentials.signer(), null).address());
    }

    public boolean isNull() {
        return this.value.equals(BigInteger.ZERO);
    }

    public int getType() {
        return 0;
    }

    public String makeAddrStd() {
        return this.wid() + ":" + Data.padLeftZeros(this.value().toString(16), 64);
    }
}

