/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import tech.deplant.commons.Numbers;
import tech.deplant.commons.Objs;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.binding.Net;
import tech.deplant.java4ever.binding.Processing;
import tech.deplant.java4ever.binding.Tvm;
import tech.deplant.java4ever.framework.Account;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.DebugOptions;
import tech.deplant.java4ever.framework.LogUtils;
import tech.deplant.java4ever.framework.MessageFlag;
import tech.deplant.java4ever.framework.ResultOfTree;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.contract.AbstractContract;
import tech.deplant.java4ever.framework.contract.Contract;
import tech.deplant.java4ever.framework.contract.multisig.MultisigWallet;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.datatype.TvmCell;
import tech.deplant.java4ever.framework.template.SafeMultisigWalletTemplate;

public record FunctionHandle<RETURN>(Class<RETURN> clazz, Contract contract, String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader, DebugOptions debugOptions) {
    private static System.Logger logger = System.getLogger(FunctionHandle.class.getName());

    public FunctionHandle(Class<RETURN> clazz, Contract contract, String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader) {
        this(clazz, contract, functionName, functionInputs, functionHeader, new DebugOptions(false, 60000L, false, new ContractAbi[0]));
    }

    public FunctionHandle(Class<RETURN> clazz, Sdk sdk, String address, ContractAbi abi, Credentials credentials, String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader) {
        this(clazz, new AbstractContract(sdk, address, abi, credentials), functionName, functionInputs, functionHeader);
    }

    public FunctionHandle(Sdk sdk, String address, ContractAbi abi, Credentials credentials, String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader) {
        this(new HashMap().getClass(), new AbstractContract(sdk, address, abi, credentials), functionName, functionInputs, functionHeader);
    }

    public FunctionHandle<RETURN> withDebugTree(boolean enabled, long timeout, boolean throwErrors, ContractAbi ... treeAbis) {
        return new FunctionHandle<RETURN>(this.clazz(), this.contract(), this.functionName(), this.functionInputs(), this.functionHeader(), new DebugOptions(enabled, timeout, throwErrors, treeAbis));
    }

    public FunctionHandle<RETURN> withDebugTree(DebugOptions debugOptions) {
        return new FunctionHandle<RETURN>(this.clazz(), this.contract(), this.functionName(), this.functionInputs(), this.functionHeader(), debugOptions);
    }

    public FunctionHandle<RETURN> withCredentials(Credentials credentials) {
        return new FunctionHandle<RETURN>(this.clazz(), new AbstractContract(this.contract().sdk(), this.contract().address(), this.contract().abi(), credentials), this.functionName(), this.functionInputs(), this.functionHeader());
    }

    public FunctionHandle<RETURN> withFunctionInputs(Map<String, Object> functionInputs) {
        return new FunctionHandle<RETURN>(this.clazz(), this.contract(), this.functionName(), functionInputs, this.functionHeader());
    }

    public FunctionHandle<RETURN> withFunctionHeader(Abi.FunctionHeader functionHeader) {
        return new FunctionHandle<RETURN>(this.clazz(), this.contract(), this.functionName(), this.functionInputs(), functionHeader);
    }

    public <T> FunctionHandle<T> withReturnClass(Class<T> returnClass) {
        return new FunctionHandle<T>(returnClass, this.contract(), this.functionName(), this.functionInputs(), this.functionHeader());
    }

    public Abi.CallSet toCallSet() throws EverSdkException {
        Map<String, Object> converted = this.contract().abi().convertFunctionInputs(this.functionName(), this.functionInputs());
        return new Abi.CallSet(this.functionName(), this.functionHeader(), JsonContext.ABI_JSON_MAPPER().valueToTree(converted));
    }

    public RETURN toOutput(JsonNode outputMap) throws EverSdkException {
        Map<Object, Object> converted = new HashMap();
        try {
            converted = this.contract().abi().convertFunctionOutputs(this.functionName(), JsonContext.readAsMap((ObjectMapper)JsonContext.ABI_JSON_MAPPER(), (JsonNode)outputMap));
            return (RETURN)JsonContext.ABI_JSON_MAPPER().convertValue(converted, this.clazz());
        }
        catch (IOException e) {
            try {
                LogUtils.error(logger, String.format("Original: %s, Converted: %s", JsonContext.ABI_JSON_MAPPER().writeValueAsString((Object)outputMap), JsonContext.ABI_JSON_MAPPER().writeValueAsString(converted)));
                throw new RuntimeException(e);
            }
            catch (JsonProcessingException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public TvmCell toPayload() throws EverSdkException {
        return new TvmCell(Abi.encodeMessageBody((EverSdkContext)this.contract().sdk().context(), (Abi.ABI)this.contract().abi().functionCallABI(this.functionName()), (Abi.CallSet)this.toCallSet(), (Boolean)true, (Abi.Signer)this.toSigner(), null, (String)this.contract().address(), null).body());
    }

    public Abi.Signer toSigner() {
        return ((Credentials)Objs.notNullElse((Object)this.contract().credentials(), (Object)Credentials.NONE)).signer();
    }

    public JsonNode getAsMap() throws EverSdkException {
        HashMap<String, Account.GraphQLFilter.In> filter = new HashMap<String, Account.GraphQLFilter.In>();
        filter.put("id", new Account.GraphQLFilter.In(new String[]{this.contract().address()}));
        Net.ResultOfQueryCollection result = Net.queryCollection((EverSdkContext)this.contract().sdk().context(), (String)"accounts", (JsonNode)JsonContext.ABI_JSON_MAPPER().valueToTree(filter), (String)"id boc", null, null);
        Abi.ResultOfEncodeMessage msg = Abi.encodeMessage((EverSdkContext)this.contract().sdk().context(), (Abi.ABI)this.contract().abi().functionCallABI(this.functionName()), (String)this.contract().address(), null, (Abi.CallSet)this.toCallSet(), (Abi.Signer)this.toSigner(), null, null);
        JsonNode[] jsonNodeArray = result.result();
        int n = jsonNodeArray.length;
        int n2 = 0;
        if (n2 < n) {
            JsonNode map = jsonNodeArray[n2];
            String boc = map.get("boc").asText();
            return Optional.ofNullable(Tvm.runTvm((EverSdkContext)this.contract().sdk().context(), (String)msg.message(), (String)boc, null, (Abi.ABI)this.contract().abi().ABI(), null, (Boolean)false).decoded().output()).orElse(JsonContext.EMPTY_NODE());
        }
        return JsonContext.EMPTY_NODE();
    }

    public RETURN get() throws EverSdkException {
        return this.toOutput(this.getAsMap());
    }

    public RETURN getLocal(String boc) throws EverSdkException {
        return this.toOutput(this.getLocalAsMap(boc));
    }

    public JsonNode getLocalAsMap(String boc) throws EverSdkException {
        Abi.ResultOfEncodeMessage msg = Abi.encodeMessage((EverSdkContext)this.contract().sdk().context(), (Abi.ABI)this.contract().abi().functionCallABI(this.functionName()), (String)this.contract().address(), null, (Abi.CallSet)this.toCallSet(), (Abi.Signer)this.toSigner(), null, null);
        return Optional.ofNullable(Tvm.runTvm((EverSdkContext)this.contract().sdk().context(), (String)msg.message(), (String)boc, null, (Abi.ABI)this.contract().abi().ABI(), null, (Boolean)false).decoded().output()).orElse(JsonContext.EMPTY_NODE());
    }

    public JsonNode callLocalAsMap(String boc, Tvm.ExecutionOptions options, boolean unlimitedBalance) throws EverSdkException {
        Abi.ResultOfEncodeMessage msg = Abi.encodeMessage((EverSdkContext)this.contract().sdk().context(), (Abi.ABI)this.contract().abi().functionCallABI(this.functionName()), (String)this.contract().address(), null, (Abi.CallSet)this.toCallSet(), (Abi.Signer)this.toSigner(), null, null);
        return Optional.ofNullable(Tvm.runExecutor((EverSdkContext)this.contract().sdk().context(), (String)msg.message(), (Tvm.AccountForExecutor)new Tvm.AccountForExecutor.Account(boc, Boolean.valueOf(unlimitedBalance)), (Tvm.ExecutionOptions)options, (Abi.ABI)this.contract().abi().ABI(), (Boolean)false, null, (Boolean)true).decoded().output()).orElse(JsonContext.EMPTY_NODE());
    }

    public RETURN callLocal(String boc, Tvm.ExecutionOptions options, boolean unlimitedBalance) throws EverSdkException {
        return this.toOutput(this.callLocalAsMap(boc, options, unlimitedBalance));
    }

    public JsonNode callAsMap() throws EverSdkException {
        Processing.ResultOfProcessMessage resultOfProcess = this.processExternalCall();
        BigDecimal balanceDeltaStr = Numbers.hexStringToBigDec((String)resultOfProcess.transaction().get("balance_delta").asText(), (int)9);
        Supplier<String> lazyFormatLogMessage = () -> String.format("\n|-----------------------------------------------------------\n|%s (%s):\n|  TR_ID: %s\n|  MSG_ID: %s\n|  (%s)--{%s E}-->(%s)\n|  Result: %d (%s)\n|  Fees: %s E\n|  Out Messages: [%s]\n|-----------------------------------------------------------\n", "EXTERNAL CALL", this.functionName, resultOfProcess.transaction().get("id").asText(), resultOfProcess.transaction().get("in_msg").asText(), "ext", new BigDecimal(resultOfProcess.fees().totalFwdFees(), 9).toPlainString(), resultOfProcess.transaction().get("account_addr").asText(), 0, this.functionName, new BigDecimal(resultOfProcess.fees().totalAccountFees(), 9).toPlainString(), "");
        LogUtils.info(logger, lazyFormatLogMessage);
        return Optional.ofNullable(resultOfProcess.decoded().output()).orElse(JsonContext.EMPTY_NODE());
    }

    public RETURN call() throws EverSdkException {
        return this.toOutput(this.callAsMap());
    }

    public ResultOfTree<JsonNode> callTreeAsMap(boolean throwOnTreeError, ContractAbi ... otherAbisForDecode) throws EverSdkException {
        Abi.ABI[] finalABIArray = (Abi.ABI[])Arrays.stream(this.concatAbiSet(otherAbisForDecode, this.contract().abi())).map(ContractAbi::ABI).toArray(Abi.ABI[]::new);
        Processing.ResultOfProcessMessage resultOfProcess = this.processExternalCall();
        String msgId = resultOfProcess.transaction().get("in_msg").asText();
        Net.ResultOfQueryTransactionTree debugOutResult = Net.queryTransactionTree((EverSdkContext)this.contract().sdk().context(), (String)msgId, (Abi.ABI[])finalABIArray, (Long)this.contract().sdk().debugTreeTimeout(), (Long)0L);
        for (Net.TransactionNode tr : debugOutResult.transactions()) {
            Net.MessageNode msg = Arrays.stream(debugOutResult.messages()).filter(msgElem -> msgElem.id().equals(tr.inMsg())).findFirst().get();
            Supplier<String> lazyFormatLogMessage = () -> String.format("\n|-----------------------------------------------------------\n|%s (%s):\n|  TR_ID: %s\n|  MSG_ID: %s\n|  (%s)--{%s E}-->(%s)\n|  Result: %d (%s)\n|  Fees: %s E\n|  Out Messages: [%s]\n|-----------------------------------------------------------\n", LogUtils.typeOfMessage(msg), LogUtils.nameOfMessage(msg), tr.id(), msg.id(), LogUtils.sourceOfMessage(msg), Numbers.hexStringToBigDec((String)msg.value(), (int)9).toPlainString(), LogUtils.destOfMessage(msg), tr.exitCode(), LogUtils.nameOfMessage(msg), Numbers.hexStringToBigDec((String)tr.totalFees(), (int)9).toPlainString(), LogUtils.enquotedListAgg(tr.outMsgs()));
            if (tr.aborted().booleanValue() && throwOnTreeError) {
                LogUtils.error(logger, lazyFormatLogMessage);
                if (Objs.isNull((Object)tr.exitCode())) {
                    throw new EverSdkException(new EverSdkException.ErrorResult(-404L, tr.toString()), "ABORTED! Exit code: -404. Target contract " + LogUtils.destOfMessage(msg) + " is not deployed!");
                }
                throw new EverSdkException(new EverSdkException.ErrorResult(tr.exitCode().longValue(), tr.toString()), "ABORTED! Exit code: %s. Transaction: %s".formatted(tr.exitCode().toString(), tr.id()));
            }
            if (tr.aborted().booleanValue()) {
                LogUtils.warn(logger, lazyFormatLogMessage);
                continue;
            }
            LogUtils.info(logger, lazyFormatLogMessage);
        }
        JsonNode map = Optional.ofNullable(resultOfProcess.decoded().output()).orElse(JsonContext.EMPTY_NODE());
        return new ResultOfTree<JsonNode>(debugOutResult, map);
    }

    public ResultOfTree<RETURN> callTree(boolean throwOnTreeError, ContractAbi ... otherAbisForDecode) throws EverSdkException {
        ResultOfTree<JsonNode> result = this.callTreeAsMap(throwOnTreeError, otherAbisForDecode);
        return new ResultOfTree<RETURN>(result.queryTree(), this.toOutput(result.decodedOutput()));
    }

    public JsonNode sendFromAsMap(MultisigWallet sender, BigInteger value, boolean bounce, MessageFlag flag) throws EverSdkException, JsonProcessingException {
        return sender.sendTransaction(new Address(this.contract().address()), value, bounce, flag.flag(), this.toPayload()).callAsMap();
    }

    public JsonNode sendFromAsMap(MultisigWallet sender, BigInteger value) throws EverSdkException, JsonProcessingException {
        return this.sendFromAsMap(sender, value, true, MessageFlag.EXACT_VALUE_GAS);
    }

    public RETURN sendFrom(MultisigWallet sender, BigInteger value, boolean bounce, MessageFlag flag) throws EverSdkException, JsonProcessingException {
        return this.toOutput(this.sendFromAsMap(sender, value, bounce, flag));
    }

    public RETURN sendFrom(MultisigWallet sender, BigInteger value) throws EverSdkException, JsonProcessingException {
        return this.toOutput(this.sendFromAsMap(sender, value));
    }

    public ResultOfTree<JsonNode> sendFromTreeAsMap(MultisigWallet sender, BigInteger value, boolean bounce, MessageFlag flag, boolean throwOnTreeError, ContractAbi ... otherAbisForDecode) throws EverSdkException, JsonProcessingException {
        return sender.sendTransaction(new Address(this.contract().address()), value, bounce, flag.flag(), this.toPayload()).callTreeAsMap(throwOnTreeError, this.concatAbiSet(otherAbisForDecode, this.contract().abi(), SafeMultisigWalletTemplate.DEFAULT_ABI()));
    }

    public ResultOfTree<RETURN> sendFromTree(MultisigWallet sender, BigInteger value, boolean bounce, MessageFlag flag, boolean throwOnTreeError, ContractAbi ... otherAbisForDecode) throws EverSdkException, JsonProcessingException {
        ResultOfTree<JsonNode> result = this.sendFromTreeAsMap(sender, value, bounce, flag, throwOnTreeError, otherAbisForDecode);
        return new ResultOfTree<RETURN>(result.queryTree(), this.toOutput(result.decodedOutput()));
    }

    private ContractAbi[] concatAbiSet(ContractAbi[] currentAbis, ContractAbi ... moreAbis) {
        HashSet<ContractAbi> abiSet = new HashSet<ContractAbi>();
        for (ContractAbi contractAbi : currentAbis) {
            abiSet.add(contractAbi);
        }
        for (ContractAbi contractAbi : moreAbis) {
            abiSet.add(contractAbi);
        }
        return (ContractAbi[])abiSet.toArray(ContractAbi[]::new);
    }

    private Processing.ResultOfProcessMessage processExternalCall() throws EverSdkException {
        return Processing.processMessage((EverSdkContext)this.contract().sdk().context(), (Abi.ABI)this.contract().abi().functionCallABI(this.functionName()), (String)this.contract().address(), null, (Abi.CallSet)this.toCallSet(), (Abi.Signer)this.toSigner(), null, null, (Boolean)false);
    }
}

