package tech.deplant.java4ever.framework.template;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.lang.Object;
import java.lang.String;
import java.math.BigInteger;
import java.util.Map;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.DeployHandle;
import tech.deplant.java4ever.framework.Tvc;
import tech.deplant.java4ever.framework.contract.tip4.TIP4NftContract;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.datatype.TvmCell;

/**
 * Java template class for deploy of <strong>TIP4NftContract</strong> contract for Everscale blockchain.
 */
public record TIP4NftTemplate(ContractAbi abi, Tvc tvc) implements Template {
  public TIP4NftTemplate(Tvc tvc) throws JsonProcessingException {
    this(DEFAULT_ABI(), tvc);
  }

  public TIP4NftTemplate() throws JsonProcessingException {
    this(DEFAULT_ABI(),DEFAULT_TVC());
  }

  public static ContractAbi DEFAULT_ABI() throws JsonProcessingException {
    return ContractAbi.ofString("{\"version\":\"2.2\",\"header\":[\"pubkey\",\"time\",\"expire\"],\"functions\":[{\"name\":\"constructor\",\"inputs\":[{\"name\":\"owner\",\"type\":\"address\"},{\"name\":\"sendGasTo\",\"type\":\"address\"},{\"name\":\"remainOnNft\",\"type\":\"uint128\"},{\"name\":\"json\",\"type\":\"string\"},{\"name\":\"indexDeployValue\",\"type\":\"uint128\"},{\"name\":\"indexDestroyValue\",\"type\":\"uint128\"},{\"name\":\"codeIndex\",\"type\":\"cell\"}],\"outputs\":[]},{\"name\":\"burn\",\"inputs\":[{\"name\":\"dest\",\"type\":\"address\"}],\"outputs\":[]},{\"name\":\"indexCode\",\"inputs\":[{\"name\":\"answerId\",\"type\":\"uint32\"}],\"outputs\":[{\"name\":\"code\",\"type\":\"cell\"}]},{\"name\":\"indexCodeHash\",\"inputs\":[{\"name\":\"answerId\",\"type\":\"uint32\"}],\"outputs\":[{\"name\":\"hash\",\"type\":\"uint256\"}]},{\"name\":\"resolveIndex\",\"inputs\":[{\"name\":\"answerId\",\"type\":\"uint32\"},{\"name\":\"collection\",\"type\":\"address\"},{\"name\":\"owner\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"index\",\"type\":\"address\"}]},{\"name\":\"getJson\",\"inputs\":[{\"name\":\"answerId\",\"type\":\"uint32\"}],\"outputs\":[{\"name\":\"json\",\"type\":\"string\"}]},{\"name\":\"transfer\",\"inputs\":[{\"name\":\"to\",\"type\":\"address\"},{\"name\":\"sendGasTo\",\"type\":\"address\"},{\"name\":\"callbacks\",\"type\":\"map(address,tuple)\",\"components\":[{\"name\":\"value\",\"type\":\"uint128\"},{\"name\":\"payload\",\"type\":\"cell\"}]}],\"outputs\":[]},{\"name\":\"changeOwner\",\"inputs\":[{\"name\":\"newOwner\",\"type\":\"address\"},{\"name\":\"sendGasTo\",\"type\":\"address\"},{\"name\":\"callbacks\",\"type\":\"map(address,tuple)\",\"components\":[{\"name\":\"value\",\"type\":\"uint128\"},{\"name\":\"payload\",\"type\":\"cell\"}]}],\"outputs\":[]},{\"name\":\"changeManager\",\"inputs\":[{\"name\":\"newManager\",\"type\":\"address\"},{\"name\":\"sendGasTo\",\"type\":\"address\"},{\"name\":\"callbacks\",\"type\":\"map(address,tuple)\",\"components\":[{\"name\":\"value\",\"type\":\"uint128\"},{\"name\":\"payload\",\"type\":\"cell\"}]}],\"outputs\":[]},{\"name\":\"getInfo\",\"inputs\":[{\"name\":\"answerId\",\"type\":\"uint32\"}],\"outputs\":[{\"name\":\"id\",\"type\":\"uint256\"},{\"name\":\"owner\",\"type\":\"address\"},{\"name\":\"manager\",\"type\":\"address\"},{\"name\":\"collection\",\"type\":\"address\"}]},{\"name\":\"supportsInterface\",\"inputs\":[{\"name\":\"answerId\",\"type\":\"uint32\"},{\"name\":\"interfaceID\",\"type\":\"uint32\"}],\"outputs\":[{\"name\":\"value0\",\"type\":\"bool\"}]}],\"events\":[{\"name\":\"NftCreated\",\"inputs\":[{\"name\":\"id\",\"type\":\"uint256\"},{\"name\":\"owner\",\"type\":\"address\"},{\"name\":\"manager\",\"type\":\"address\"},{\"name\":\"collection\",\"type\":\"address\"}]},{\"name\":\"OwnerChanged\",\"inputs\":[{\"name\":\"oldOwner\",\"type\":\"address\"},{\"name\":\"newOwner\",\"type\":\"address\"}]},{\"name\":\"ManagerChanged\",\"inputs\":[{\"name\":\"oldManager\",\"type\":\"address\"},{\"name\":\"newManager\",\"type\":\"address\"}]},{\"name\":\"NftBurned\",\"inputs\":[{\"name\":\"id\",\"type\":\"uint256\"},{\"name\":\"owner\",\"type\":\"address\"},{\"name\":\"manager\",\"type\":\"address\"},{\"name\":\"collection\",\"type\":\"address\"}]}],\"data\":[{\"key\":1,\"name\":\"_id\",\"type\":\"uint256\"}],\"fields\":[{\"name\":\"_pubkey\",\"type\":\"uint256\"},{\"name\":\"_timestamp\",\"type\":\"uint64\"},{\"name\":\"_constructorFlag\",\"type\":\"bool\"},{\"name\":\"_supportedInterfaces\",\"type\":\"optional(cell)\"},{\"name\":\"_id\",\"type\":\"uint256\"},{\"name\":\"_collection\",\"type\":\"address\"},{\"name\":\"_owner\",\"type\":\"address\"},{\"name\":\"_manager\",\"type\":\"address\"},{\"name\":\"_json\",\"type\":\"string\"},{\"name\":\"_indexDeployValue\",\"type\":\"uint128\"},{\"name\":\"_indexDestroyValue\",\"type\":\"uint128\"},{\"name\":\"_codeIndex\",\"type\":\"cell\"}],\"ABI version\":2}");
  }

  public static Tvc DEFAULT_TVC() {
    return Tvc.ofBase64String("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");
  }

  public DeployHandle<TIP4NftContract> prepareDeploy(int contextId, int workchainId,
      Credentials credentials, BigInteger _id, Address owner, Address sendGasTo,
      BigInteger remainOnNft, String json, BigInteger indexDeployValue,
      BigInteger indexDestroyValue, TvmCell codeIndex) {
    Map<String, Object> initialDataFields = Map.of("_id", _id);
    Map<String, Object> params = Map.of("owner", owner, 
        "sendGasTo", sendGasTo, 
        "remainOnNft", remainOnNft, 
        "json", json, 
        "indexDeployValue", indexDeployValue, 
        "indexDestroyValue", indexDestroyValue, 
        "codeIndex", codeIndex);
    return new DeployHandle<TIP4NftContract>(TIP4NftContract.class, contextId, abi(), tvc(), workchainId, credentials, initialDataFields, params, null);
  }
}
