/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import tech.deplant.java4ever.utils.Strings;

public class Numbers {
    private static String preprocessHexString(String hexString) {
        if (Strings.isEmpty((String)hexString)) {
            return "00";
        }
        if (((String)hexString).startsWith("0x")) {
            hexString = Strings.notEmptyElse(Strings.substr((String)hexString, 2), "00");
        } else if (((String)hexString).startsWith("-0x")) {
            hexString = "-" + Strings.notEmptyElse(Strings.substr((String)hexString, 3), "00");
        }
        return Strings.notEmptyElse((String)hexString, "00");
    }

    public static int hexStringToInt(String hexString) {
        return Integer.parseInt(Numbers.preprocessHexString(hexString), 16);
    }

    public static long hexStringToLong(String hexString) {
        return Long.parseLong(Numbers.preprocessHexString(hexString), 16);
    }

    public static BigInteger hexStringToBigInt(String hexString) {
        return new BigInteger(Numbers.preprocessHexString(hexString), 16);
    }

    public static BigDecimal hexStringToBigDec(String hexString, int scale) {
        return new BigDecimal(Numbers.hexStringToBigInt(hexString), scale);
    }
}

