/*
 * Decompiled with CFR 0.152.
 */
package tech.hiddenproject.compaj.plugin.api.event;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.hiddenproject.compaj.plugin.api.event.CompaJEvent;
import tech.hiddenproject.compaj.plugin.api.event.PublisherSubscription;
import tech.hiddenproject.compaj.plugin.api.event.PublisherType;

public enum EventPublisher {
    INSTANCE;

    private static final Logger LOGGER;
    private final AtomicLong generator;
    private final Map<String, Map<Long, Consumer<CompaJEvent>>> feed = new ConcurrentHashMap<String, Map<Long, Consumer<CompaJEvent>>>();
    private PublisherType publisherType = PublisherType.PARALLEL;

    private EventPublisher() {
        this.generator = new AtomicLong(0L);
    }

    public void sendTo(String topic, CompaJEvent message) {
        Map subscribers = this.feed.getOrDefault(topic, new HashMap());
        LOGGER.info("Event {} on {}", (Object)message, (Object)topic);
        switch (this.publisherType) {
            case SEQUENCE: {
                this.sendSequence(message, subscribers);
                break;
            }
            case PARALLEL: {
                this.sendParallel(message, subscribers);
            }
        }
    }

    public PublisherSubscription subscribeOn(String topic, Consumer<CompaJEvent> action) {
        this.feed.putIfAbsent(topic, new ConcurrentHashMap());
        long id = this.generator.incrementAndGet();
        this.feed.get(topic).put(id, action);
        return new PublisherSubscription(topic, id);
    }

    public void unsubscribe(PublisherSubscription subscription) {
        ((Map)this.feed.getOrDefault(subscription.topic(), new HashMap())).remove(subscription.id());
    }

    PublisherType getPublisherType() {
        return this.publisherType;
    }

    void setPublisherType(PublisherType publisherType) {
        this.publisherType = publisherType;
    }

    private void sendSequence(CompaJEvent message, Map<Long, Consumer<CompaJEvent>> subscribers) {
        for (Consumer<CompaJEvent> compaJEventConsumer : subscribers.values()) {
            compaJEventConsumer.accept(message);
        }
    }

    private void sendParallel(CompaJEvent message, Map<Long, Consumer<CompaJEvent>> subscribers) {
        ((Stream)subscribers.values().parallelStream().unordered()).forEach(l -> l.accept(message));
    }

    static {
        LOGGER = LoggerFactory.getLogger(EventPublisher.class);
    }
}

