/*
 * Decompiled with CFR 0.152.
 */
package top.codewood.wx.mnp.api;

import com.google.gson.JsonObject;
import top.codewood.wx.common.api.WxBaseHttpApi;
import top.codewood.wx.mnp.bean.plugin.WxMnpPluginListResult;
import top.codewood.wx.mnp.util.json.WxGsonBuilder;

public class WxMnpPluginApi
extends WxBaseHttpApi {
    public static WxMnpPluginApi getInstance() {
        return Holder.INSTANCE;
    }

    public WxMnpPluginListResult getPluginList(String accessToken) {
        assert (accessToken != null);
        String url = String.format("https://api.weixin.qq.com/wxa/plugin?access_token=%s", accessToken);
        String postData = "{\"action\":\"list\"}";
        String respStr = WxMnpPluginApi.post((String)url, (String)postData);
        return (WxMnpPluginListResult)WxGsonBuilder.instance().fromJson(respStr, WxMnpPluginListResult.class);
    }

    public void applyPlugin(String accessToken, String pluginAppid, String reason) {
        assert (accessToken != null && pluginAppid != null);
        String url = String.format("https://api.weixin.qq.com/wxa/plugin?access_token=%s", accessToken);
        JsonObject json = new JsonObject();
        json.addProperty("action", "apply");
        json.addProperty("plugin_appid", pluginAppid);
        if (reason != null) {
            json.addProperty("reason", reason);
        }
        WxMnpPluginApi.post((String)url, (String)json.toString());
    }

    public void unbindPlugin(String accessToken, String pluginAppid) {
        assert (accessToken != null && pluginAppid != null);
        String url = String.format("https://api.weixin.qq.com/wxa/plugin?access_token=%s", accessToken);
        JsonObject json = new JsonObject();
        json.addProperty("action", "unbind");
        json.addProperty("plugin_appid", pluginAppid);
        WxMnpPluginApi.post((String)url, (String)json.toString());
    }

    private static class Holder {
        private static final WxMnpPluginApi INSTANCE = new WxMnpPluginApi();

        private Holder() {
        }
    }
}

