/*
 * Decompiled with CFR 0.152.
 */
package top.codewood.wx.mnp.api;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import top.codewood.wx.common.api.WxBaseHttpApi;
import top.codewood.wx.common.util.file.FileUtils;
import top.codewood.wx.mnp.util.json.WxGsonBuilder;

public class WxMnpSecCheckApi
extends WxBaseHttpApi {
    public static WxMnpSecCheckApi getInstance() {
        return Holder.INSTANCE;
    }

    public void imgSecCheck(String accessToken, File file) {
        assert (accessToken != null && file != null);
        String url = String.format("https://api.weixin.qq.com/wxa/img_sec_check?access_token=%s", accessToken);
        WxMnpSecCheckApi.upload((String)url, (File)file);
    }

    public void imgSecCheck(String accessToken, InputStream inputStream) throws IOException {
        assert (accessToken != null && inputStream != null);
        File tmpFile = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg");
        this.imgSecCheck(accessToken, tmpFile);
    }

    public String mediaCheckAsync(String accessToken, String mediaUrl, int mediaType) {
        assert (accessToken != null && mediaUrl != null);
        String url = String.format("https://api.weixin.qq.com/wxa/media_check_async?access_token=%s", accessToken);
        JsonObject json = new JsonObject();
        json.addProperty("media_url", mediaUrl);
        json.addProperty("media_type", (Number)mediaType);
        String respStr = WxMnpSecCheckApi.post((String)url, (String)json.toString());
        JsonObject retJson = (JsonObject)WxGsonBuilder.instance().fromJson(respStr, JsonObject.class);
        return retJson.get("trace_id").getAsString();
    }

    public void msgSecCheck(String accessToken, String content) {
        assert (accessToken != null && content != null);
        String url = String.format("https://api.weixin.qq.com/wxa/msg_sec_check?access_token=%s", accessToken);
        String postData = String.format("{\"content\":\"%s\"}", content);
        WxMnpSecCheckApi.post((String)url, (String)postData);
    }

    private static class Holder {
        private static final WxMnpSecCheckApi INSTANCE = new WxMnpSecCheckApi();

        private Holder() {
        }
    }
}

