/*
 * Decompiled with CFR 0.152.
 */
package top.codewood.wx.mnp.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import top.codewood.wx.mnp.bean.analysis.WxMnpRetainInfo;

public class WxMnpRetainInfoGsonAdapter
implements JsonDeserializer<WxMnpRetainInfo> {
    public WxMnpRetainInfo deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        WxMnpRetainInfo retainInfo = new WxMnpRetainInfo();
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject.has("ref_date")) {
            retainInfo.setRefDate(jsonObject.get("ref_date").getAsString());
        }
        retainInfo.setVisitUvNew(this.getVisitUvMap(jsonObject.get("visit_uv_new").getAsJsonArray()));
        retainInfo.setVisitUv(this.getVisitUvMap(jsonObject.get("visit_uv").getAsJsonArray()));
        return retainInfo;
    }

    private Map<Integer, Integer> getVisitUvMap(JsonArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        LinkedHashMap<Integer, Integer> map = new LinkedHashMap<Integer, Integer>(jsonArray.size());
        for (JsonElement jsonEle : jsonArray) {
            JsonObject jsonObj = jsonEle.getAsJsonObject();
            if (jsonObj.get("key").isJsonNull()) continue;
            Integer key = jsonObj.get("key").getAsInt();
            Integer value = jsonObj.get("value").getAsInt();
            map.put(key, value);
        }
        return map;
    }
}

