/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.express.connector.jetty;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import us.codecraft.express.WebServer;
import us.codecraft.express.connector.AbstractWebServer;
import us.codecraft.express.router.UrlRouter;

public class JettyWebServer
extends AbstractWebServer {
    private Server server;

    @Override
    public WebServer stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        return this;
    }

    @Override
    public WebServer start() throws Exception {
        this.server = new Server(this.getPort());
        this.server.setHandler((Handler)new WebServerHandler(this.getUrlRouter()));
        this.server.start();
        return this;
    }

    static class WebServerHandler
    extends AbstractHandler {
        private UrlRouter urlRouter;

        WebServerHandler(UrlRouter urlRouter) {
            this.urlRouter = urlRouter;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            try {
                this.urlRouter.route(request).execute(request, response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

