/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.express.router;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import us.codecraft.express.router.UrlMatcher;

public class RegexUrlMatcher
extends UrlMatcher {
    private Pattern pattern;
    private List<String> pathVariables;
    private static Pattern variablesPattern = Pattern.compile("\\$\\{(\\w+)\\}");

    public RegexUrlMatcher(Pattern pattern, List<String> pathVariables) {
        this.pattern = pattern;
        this.pathVariables = pathVariables;
    }

    @Override
    public boolean match(HttpServletRequest request) {
        Matcher matcher = this.pattern.matcher(request.getRequestURI());
        if (matcher.matches()) {
            if (this.pathVariables != null && this.pathVariables.size() > 0) {
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    request.setAttribute(this.pathVariables.get(i), (Object)matcher.group(i + 1));
                }
            }
            return true;
        }
        return false;
    }

    public static RegexUrlMatcher compile(String url) {
        Matcher matcher = variablesPattern.matcher(url);
        StringBuffer accum = new StringBuffer();
        ArrayList<String> pathVariables = new ArrayList<String>();
        while (matcher.find()) {
            pathVariables.add(matcher.group(1));
            matcher.appendReplacement(accum, "([^/]+)");
        }
        matcher.appendTail(accum);
        return new RegexUrlMatcher(Pattern.compile(accum.toString()), pathVariables);
    }

    public String toString() {
        return "RegexUrlMatcher{pattern=" + this.pattern + ", pathVariables=" + this.pathVariables + '}';
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public List<String> getPathVariables() {
        return this.pathVariables;
    }
}

