/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.express.router;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import us.codecraft.express.controller.Controller;
import us.codecraft.express.router.MatcherAndController;
import us.codecraft.express.router.UrlMatcher;

public class UrlRouter {
    private Map<String, MatcherAndController> getRouters = new LinkedHashMap<String, MatcherAndController>();
    private Map<String, MatcherAndController> postRouters = new LinkedHashMap<String, MatcherAndController>();
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addController(String url, Controller controller, String method) {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            if ("get".equalsIgnoreCase(method)) {
                this.getRouters.put(url, new MatcherAndController(UrlMatcher.compile(url), controller));
            } else if ("post".equalsIgnoreCase(method)) {
                this.postRouters.put(url, new MatcherAndController(UrlMatcher.compile(url), controller));
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Controller route(HttpServletRequest request) {
        block8: {
            Lock readLock = this.readWriteLock.readLock();
            readLock.lock();
            try {
                if ("get".equalsIgnoreCase(request.getMethod())) {
                    for (MatcherAndController matcherAndController : this.getRouters.values()) {
                        if (!matcherAndController.getMatcher().match(request)) continue;
                        Controller controller = matcherAndController.getController();
                        return controller;
                    }
                    break block8;
                }
                if (!"post".equalsIgnoreCase(request.getMethod())) break block8;
                for (MatcherAndController matcherAndController : this.postRouters.values()) {
                    if (!matcherAndController.getMatcher().match(request)) continue;
                    Controller controller = matcherAndController.getController();
                    return controller;
                }
            }
            finally {
                readLock.unlock();
            }
        }
        return null;
    }
}

