/*
 * Decompiled with CFR 0.152.
 */
package wf.bitcoin.javabitcoindrpcclient;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRPCException;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRpcException;
import wf.bitcoin.javabitcoindrpcclient.BitcoinUtil;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;
import wf.bitcoin.javabitcoindrpcclient.ListMapWrapper;
import wf.bitcoin.javabitcoindrpcclient.MapWrapper;
import wf.bitcoin.krotjson.Base64Coder;
import wf.bitcoin.krotjson.JSON;

public class BitcoinJSONRPCClient
implements BitcoindRpcClient {
    private static final Logger logger;
    public final URL rpcURL;
    private URL noAuthURL;
    private String authStr;
    public static final URL DEFAULT_JSONRPC_URL;
    public static final URL DEFAULT_JSONRPC_TESTNET_URL;
    private HostnameVerifier hostnameVerifier = null;
    private SSLSocketFactory sslSocketFactory = null;
    public static final Charset QUERY_CHARSET;

    public BitcoinJSONRPCClient(String rpcUrl) throws MalformedURLException {
        this(new URL(rpcUrl));
    }

    public BitcoinJSONRPCClient(URL rpc) {
        this.rpcURL = rpc;
        try {
            this.noAuthURL = new URI(rpc.getProtocol(), null, rpc.getHost(), rpc.getPort(), rpc.getPath(), rpc.getQuery(), null).toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new IllegalArgumentException(rpc.toString(), ex);
        }
        this.authStr = rpc.getUserInfo() == null ? null : String.valueOf(Base64Coder.encode(rpc.getUserInfo().getBytes(Charset.forName("ISO8859-1"))));
    }

    public BitcoinJSONRPCClient(boolean testNet) {
        this(testNet ? DEFAULT_JSONRPC_TESTNET_URL : DEFAULT_JSONRPC_URL);
    }

    public BitcoinJSONRPCClient() {
        this(DEFAULT_JSONRPC_TESTNET_URL);
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public byte[] prepareRequest(final String method, final Object ... params) {
        return JSON.stringify(new LinkedHashMap(){
            {
                this.put("method", method);
                this.put("params", params);
                this.put("id", "1");
            }
        }).getBytes(QUERY_CHARSET);
    }

    private static byte[] loadStream(InputStream in, boolean close) throws IOException {
        int nr;
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((nr = in.read(buffer)) != -1) {
            if (nr == 0) {
                throw new IOException("Read timed out");
            }
            o.write(buffer, 0, nr);
        }
        return o.toByteArray();
    }

    public Object loadResponse(InputStream in, Object expectedID, boolean close) throws IOException, BitcoinRpcException {
        try {
            String r = new String(BitcoinJSONRPCClient.loadStream(in, close), QUERY_CHARSET);
            logger.log(Level.FINE, "Bitcoin JSON-RPC response:\n{0}", r);
            try {
                Map response = (Map)JSON.parse(r);
                if (!expectedID.equals(response.get("id"))) {
                    throw new BitcoinRPCException("Wrong response ID (expected: " + String.valueOf(expectedID) + ", response: " + response.get("id") + ")");
                }
                if (response.get("error") != null) {
                    throw new BitcoinRpcException(JSON.stringify(response.get("error")));
                }
                Object v = response.get("result");
                return v;
            }
            catch (ClassCastException ex) {
                throw new BitcoinRPCException("Invalid server response format (data: \"" + r + "\")");
            }
        }
        finally {
            if (close) {
                in.close();
            }
        }
    }

    public Object query(String method, Object ... o) throws BitcoinRpcException {
        try {
            HttpURLConnection conn = (HttpURLConnection)this.noAuthURL.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            if (conn instanceof HttpsURLConnection) {
                if (this.hostnameVerifier != null) {
                    ((HttpsURLConnection)conn).setHostnameVerifier(this.hostnameVerifier);
                }
                if (this.sslSocketFactory != null) {
                    ((HttpsURLConnection)conn).setSSLSocketFactory(this.sslSocketFactory);
                }
            }
            conn.setRequestProperty("Authorization", "Basic " + this.authStr);
            byte[] r = this.prepareRequest(method, o);
            logger.log(Level.FINE, "Bitcoin JSON-RPC request:\n{0}", new String(r, QUERY_CHARSET));
            conn.getOutputStream().write(r);
            conn.getOutputStream().close();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                throw new BitcoinRPCException("RPC Query Failed (method: " + method + ", params: " + Arrays.deepToString(o) + ", response header: " + responseCode + " " + conn.getResponseMessage() + ", response: " + new String(BitcoinJSONRPCClient.loadStream(conn.getErrorStream(), true)));
            }
            return this.loadResponse(conn.getInputStream(), "1", true);
        }
        catch (IOException ex) {
            throw new BitcoinRPCException("RPC Query Failed (method: " + method + ", params: " + Arrays.deepToString(o) + ")", ex);
        }
    }

    @Override
    public String createRawTransaction(List<BitcoindRpcClient.TxInput> inputs, List<BitcoindRpcClient.TxOutput> outputs) throws BitcoinRpcException {
        ArrayList<2> pInputs = new ArrayList<2>();
        for (final BitcoindRpcClient.TxInput txInput : inputs) {
            pInputs.add(new LinkedHashMap(){
                {
                    this.put("txid", txInput.txid());
                    this.put("vout", txInput.vout());
                }
            });
        }
        LinkedHashMap<String, Double> pOutputs = new LinkedHashMap<String, Double>();
        for (BitcoindRpcClient.TxOutput txOutput : outputs) {
            Double oldValue = pOutputs.put(txOutput.address(), txOutput.amount());
            if (oldValue == null) continue;
            pOutputs.put(txOutput.address(), BitcoinUtil.normalizeAmount(oldValue + txOutput.amount()));
        }
        return (String)this.query("createrawtransaction", pInputs, pOutputs);
    }

    @Override
    public String dumpPrivKey(String address) throws BitcoinRpcException {
        return (String)this.query("dumpprivkey", address);
    }

    @Override
    public String getAccount(String address) throws BitcoinRpcException {
        return (String)this.query("getaccount", address);
    }

    @Override
    public List<String> getAddressesByAccount(String account) throws BitcoinRpcException {
        return (List)this.query("getaddressesbyaccount", account);
    }

    @Override
    public double getBalance() throws BitcoinRpcException {
        return ((Number)this.query("getbalance", new Object[0])).doubleValue();
    }

    @Override
    public double getBalance(String account) throws BitcoinRpcException {
        return ((Number)this.query("getbalance", account)).doubleValue();
    }

    @Override
    public double getBalance(String account, int minConf) throws BitcoinRpcException {
        return ((Number)this.query("getbalance", account, minConf)).doubleValue();
    }

    @Override
    public BitcoindRpcClient.Block getBlock(int height) throws BitcoinRpcException {
        String hash = (String)this.query("getblockhash", height);
        return this.getBlock(hash);
    }

    @Override
    public BitcoindRpcClient.Block getBlock(String blockHash) throws BitcoinRpcException {
        return new BlockMapWrapper((Map)this.query("getblock", blockHash));
    }

    @Override
    public String getBlockHash(int height) throws BitcoinRpcException {
        return (String)this.query("getblockhash", height);
    }

    @Override
    public BitcoindRpcClient.BlockChainInfo getBlockChainInfo() throws BitcoinRpcException {
        return new BlockChainInfoMapWrapper((Map)this.query("getblockchaininfo", new Object[0]));
    }

    @Override
    public int getBlockCount() throws BitcoinRpcException {
        return ((Number)this.query("getblockcount", new Object[0])).intValue();
    }

    @Override
    public String getNewAddress() throws BitcoinRpcException {
        return (String)this.query("getnewaddress", new Object[0]);
    }

    @Override
    public String getNewAddress(String account) throws BitcoinRpcException {
        return (String)this.query("getnewaddress", account);
    }

    @Override
    public List<String> getRawMemPool() throws BitcoinRpcException {
        return (List)this.query("getrawmempool", new Object[0]);
    }

    @Override
    public String getBestBlockHash() throws BitcoinRpcException {
        return (String)this.query("getbestblockhash", new Object[0]);
    }

    @Override
    public String getRawTransactionHex(String txId) throws BitcoinRpcException {
        return (String)this.query("getrawtransaction", txId);
    }

    @Override
    public BitcoindRpcClient.RawTransaction getRawTransaction(String txId) throws BitcoinRpcException {
        return new RawTransactionImpl((Map)this.query("getrawtransaction", txId, 1));
    }

    @Override
    public double getReceivedByAddress(String address) throws BitcoinRpcException {
        return ((Number)this.query("getreceivedbyaddress", address)).doubleValue();
    }

    @Override
    public double getReceivedByAddress(String address, int minConf) throws BitcoinRpcException {
        return ((Number)this.query("getreceivedbyaddress", address, minConf)).doubleValue();
    }

    @Override
    public void importPrivKey(String bitcoinPrivKey) throws BitcoinRpcException {
        this.query("importprivkey", bitcoinPrivKey);
    }

    @Override
    public void importPrivKey(String bitcoinPrivKey, String label) throws BitcoinRpcException {
        this.query("importprivkey", bitcoinPrivKey, label);
    }

    @Override
    public void importPrivKey(String bitcoinPrivKey, String label, boolean rescan) throws BitcoinRpcException {
        this.query("importprivkey", bitcoinPrivKey, label, rescan);
    }

    @Override
    public Map<String, Number> listAccounts() throws BitcoinRpcException {
        return (Map)this.query("listaccounts", new Object[0]);
    }

    @Override
    public Map<String, Number> listAccounts(int minConf) throws BitcoinRpcException {
        return (Map)this.query("listaccounts", minConf);
    }

    @Override
    public List<BitcoindRpcClient.ReceivedAddress> listReceivedByAddress() throws BitcoinRpcException {
        return new ReceivedAddressListWrapper((List)this.query("listreceivedbyaddress", new Object[0]));
    }

    @Override
    public List<BitcoindRpcClient.ReceivedAddress> listReceivedByAddress(int minConf) throws BitcoinRpcException {
        return new ReceivedAddressListWrapper((List)this.query("listreceivedbyaddress", minConf));
    }

    @Override
    public List<BitcoindRpcClient.ReceivedAddress> listReceivedByAddress(int minConf, boolean includeEmpty) throws BitcoinRpcException {
        return new ReceivedAddressListWrapper((List)this.query("listreceivedbyaddress", minConf, includeEmpty));
    }

    @Override
    public BitcoindRpcClient.TransactionsSinceBlock listSinceBlock() throws BitcoinRpcException {
        return new TransactionsSinceBlockImpl((Map)this.query("listsinceblock", new Object[0]));
    }

    @Override
    public BitcoindRpcClient.TransactionsSinceBlock listSinceBlock(String blockHash) throws BitcoinRpcException {
        return new TransactionsSinceBlockImpl((Map)this.query("listsinceblock", blockHash));
    }

    @Override
    public BitcoindRpcClient.TransactionsSinceBlock listSinceBlock(String blockHash, int targetConfirmations) throws BitcoinRpcException {
        return new TransactionsSinceBlockImpl((Map)this.query("listsinceblock", blockHash, targetConfirmations));
    }

    @Override
    public List<BitcoindRpcClient.Transaction> listTransactions() throws BitcoinRpcException {
        return new TransactionListMapWrapper((List)this.query("listtransactions", new Object[0]));
    }

    @Override
    public List<BitcoindRpcClient.Transaction> listTransactions(String account) throws BitcoinRpcException {
        return new TransactionListMapWrapper((List)this.query("listtransactions", account));
    }

    @Override
    public List<BitcoindRpcClient.Transaction> listTransactions(String account, int count) throws BitcoinRpcException {
        return new TransactionListMapWrapper((List)this.query("listtransactions", account, count));
    }

    @Override
    public List<BitcoindRpcClient.Transaction> listTransactions(String account, int count, int from) throws BitcoinRpcException {
        return new TransactionListMapWrapper((List)this.query("listtransactions", account, count, from));
    }

    @Override
    public List<BitcoindRpcClient.Unspent> listUnspent() throws BitcoinRpcException {
        return new UnspentListWrapper((List)this.query("listunspent", new Object[0]));
    }

    @Override
    public List<BitcoindRpcClient.Unspent> listUnspent(int minConf) throws BitcoinRpcException {
        return new UnspentListWrapper((List)this.query("listunspent", minConf));
    }

    @Override
    public List<BitcoindRpcClient.Unspent> listUnspent(int minConf, int maxConf) throws BitcoinRpcException {
        return new UnspentListWrapper((List)this.query("listunspent", minConf, maxConf));
    }

    @Override
    public List<BitcoindRpcClient.Unspent> listUnspent(int minConf, int maxConf, String ... addresses) throws BitcoinRpcException {
        return new UnspentListWrapper((List)this.query("listunspent", minConf, maxConf, addresses));
    }

    @Override
    public String sendFrom(String fromAccount, String toBitcoinAddress, double amount) throws BitcoinRpcException {
        return (String)this.query("sendfrom", fromAccount, toBitcoinAddress, amount);
    }

    @Override
    public String sendFrom(String fromAccount, String toBitcoinAddress, double amount, int minConf) throws BitcoinRpcException {
        return (String)this.query("sendfrom", fromAccount, toBitcoinAddress, amount, minConf);
    }

    @Override
    public String sendFrom(String fromAccount, String toBitcoinAddress, double amount, int minConf, String comment) throws BitcoinRpcException {
        return (String)this.query("sendfrom", fromAccount, toBitcoinAddress, amount, minConf, comment);
    }

    @Override
    public String sendFrom(String fromAccount, String toBitcoinAddress, double amount, int minConf, String comment, String commentTo) throws BitcoinRpcException {
        return (String)this.query("sendfrom", fromAccount, toBitcoinAddress, amount, minConf, comment, commentTo);
    }

    @Override
    public String sendRawTransaction(String hex) throws BitcoinRpcException {
        return (String)this.query("sendrawtransaction", hex);
    }

    @Override
    public String sendToAddress(String toAddress, double amount) throws BitcoinRpcException {
        return (String)this.query("sendtoaddress", toAddress, amount);
    }

    @Override
    public String sendToAddress(String toAddress, double amount, String comment) throws BitcoinRpcException {
        return (String)this.query("sendtoaddress", toAddress, amount, comment);
    }

    @Override
    public String sendToAddress(String toAddress, double amount, String comment, String commentTo) throws BitcoinRpcException {
        return (String)this.query("sendtoaddress", toAddress, amount, comment, commentTo);
    }

    @Override
    public String signRawTransaction(String hex) throws BitcoinRpcException {
        Map result = (Map)this.query("signrawtransaction", hex);
        if (((Boolean)result.get("complete")).booleanValue()) {
            return (String)result.get("hex");
        }
        throw new BitcoinRpcException("Incomplete");
    }

    @Override
    public BitcoindRpcClient.AddressValidationResult validateAddress(String address) throws BitcoinRpcException {
        final Map validationResult = (Map)this.query("validateaddress", address);
        return new BitcoindRpcClient.AddressValidationResult(){

            @Override
            public boolean isValid() {
                return (Boolean)validationResult.get("isvalid");
            }

            @Override
            public String address() {
                return (String)validationResult.get("address");
            }

            @Override
            public boolean isMine() {
                return (Boolean)validationResult.get("ismine");
            }

            @Override
            public boolean isScript() {
                return (Boolean)validationResult.get("isscript");
            }

            @Override
            public String pubKey() {
                return (String)validationResult.get("pubkey");
            }

            @Override
            public boolean isCompressed() {
                return (Boolean)validationResult.get("iscompressed");
            }

            @Override
            public String account() {
                return (String)validationResult.get("account");
            }

            public String toString() {
                return validationResult.toString();
            }
        };
    }

    @Override
    public void setGenerate(int numBlocks) throws BitcoinRPCException {
        this.query("setgenerate", true, numBlocks);
    }

    static {
        String port;
        String host;
        String password;
        String user;
        block17: {
            logger = Logger.getLogger(BitcoinJSONRPCClient.class.getCanonicalName());
            user = "user";
            password = "pass";
            host = "localhost";
            port = null;
            try {
                File home = new File(System.getProperty("user.home"));
                File f = new File(home, ".bitcoin" + File.separatorChar + "bitcoin.conf");
                if (!f.exists() && !(f = new File(home, "AppData" + File.separatorChar + "Roaming" + File.separatorChar + "Bitcoin" + File.separatorChar + "bitcoin.conf")).exists()) {
                    f = null;
                }
                if (f == null) break block17;
                logger.fine("Bitcoin configuration file found");
                Properties p = new Properties();
                try (FileInputStream i = new FileInputStream(f);){
                    p.load(i);
                }
                user = p.getProperty("rpcuser", user);
                password = p.getProperty("rpcpassword", password);
                host = p.getProperty("rpcconnect", host);
                port = p.getProperty("rpcport", port);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        try {
            DEFAULT_JSONRPC_URL = new URL("http://" + user + ':' + password + "@" + host + ":" + (port == null ? "8332" : port) + "/");
            DEFAULT_JSONRPC_TESTNET_URL = new URL("http://" + user + ':' + password + "@" + host + ":" + (port == null ? "18332" : port) + "/");
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        QUERY_CHARSET = Charset.forName("ISO8859-1");
    }

    private class UnspentListWrapper
    extends ListMapWrapper<BitcoindRpcClient.Unspent> {
        public UnspentListWrapper(List<Map> list) {
            super(list);
        }

        @Override
        protected BitcoindRpcClient.Unspent wrap(final Map m) {
            return new BitcoindRpcClient.Unspent(){

                @Override
                public String txid() {
                    return MapWrapper.mapStr(m, "txid");
                }

                @Override
                public int vout() {
                    return MapWrapper.mapInt(m, "vout");
                }

                @Override
                public String address() {
                    return MapWrapper.mapStr(m, "address");
                }

                @Override
                public String scriptPubKey() {
                    return MapWrapper.mapStr(m, "scriptPubKey");
                }

                @Override
                public String account() {
                    return MapWrapper.mapStr(m, "account");
                }

                @Override
                public double amount() {
                    return MapWrapper.mapDouble(m, "amount");
                }

                @Override
                public int confirmations() {
                    return MapWrapper.mapInt(m, "confirmations");
                }
            };
        }
    }

    private class TransactionsSinceBlockImpl
    implements BitcoindRpcClient.TransactionsSinceBlock {
        public final List<BitcoindRpcClient.Transaction> transactions;
        public final String lastBlock;

        public TransactionsSinceBlockImpl(Map r) {
            this.transactions = new TransactionListMapWrapper((List)r.get("transactions"));
            this.lastBlock = (String)r.get("lastblock");
        }

        @Override
        public List<BitcoindRpcClient.Transaction> transactions() {
            return this.transactions;
        }

        @Override
        public String lastBlock() {
            return this.lastBlock;
        }
    }

    private class TransactionListMapWrapper
    extends ListMapWrapper<BitcoindRpcClient.Transaction> {
        public TransactionListMapWrapper(List<Map> list) {
            super(list);
        }

        @Override
        protected BitcoindRpcClient.Transaction wrap(final Map m) {
            return new BitcoindRpcClient.Transaction(){
                private BitcoindRpcClient.RawTransaction raw = null;

                @Override
                public String account() {
                    return MapWrapper.mapStr(m, "account");
                }

                @Override
                public String address() {
                    return MapWrapper.mapStr(m, "address");
                }

                @Override
                public String category() {
                    return MapWrapper.mapStr(m, "category");
                }

                @Override
                public double amount() {
                    return MapWrapper.mapDouble(m, "amount");
                }

                @Override
                public double fee() {
                    return MapWrapper.mapDouble(m, "fee");
                }

                @Override
                public int confirmations() {
                    return MapWrapper.mapInt(m, "confirmations");
                }

                @Override
                public String blockHash() {
                    return MapWrapper.mapStr(m, "blockhash");
                }

                @Override
                public int blockIndex() {
                    return MapWrapper.mapInt(m, "blockindex");
                }

                @Override
                public Date blockTime() {
                    return MapWrapper.mapCTime(m, "blocktime");
                }

                @Override
                public String txId() {
                    return MapWrapper.mapStr(m, "txid");
                }

                @Override
                public Date time() {
                    return MapWrapper.mapCTime(m, "time");
                }

                @Override
                public Date timeReceived() {
                    return MapWrapper.mapCTime(m, "timereceived");
                }

                @Override
                public String comment() {
                    return MapWrapper.mapStr(m, "comment");
                }

                @Override
                public String commentTo() {
                    return MapWrapper.mapStr(m, "to");
                }

                @Override
                public BitcoindRpcClient.RawTransaction raw() {
                    if (this.raw == null) {
                        try {
                            this.raw = BitcoinJSONRPCClient.this.getRawTransaction(this.txId());
                        }
                        catch (BitcoinRpcException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    return this.raw;
                }

                public String toString() {
                    return m.toString();
                }
            };
        }
    }

    private static class ReceivedAddressListWrapper
    extends AbstractList<BitcoindRpcClient.ReceivedAddress> {
        private final List<Map<String, Object>> wrappedList;

        public ReceivedAddressListWrapper(List<Map<String, Object>> wrappedList) {
            this.wrappedList = wrappedList;
        }

        @Override
        public BitcoindRpcClient.ReceivedAddress get(int index) {
            final Map<String, Object> e = this.wrappedList.get(index);
            return new BitcoindRpcClient.ReceivedAddress(){

                @Override
                public String address() {
                    return (String)e.get("address");
                }

                @Override
                public String account() {
                    return (String)e.get("account");
                }

                @Override
                public double amount() {
                    return ((Number)e.get("amount")).doubleValue();
                }

                @Override
                public int confirmations() {
                    return ((Number)e.get("confirmations")).intValue();
                }

                public String toString() {
                    return e.toString();
                }
            };
        }

        @Override
        public int size() {
            return this.wrappedList.size();
        }
    }

    private class RawTransactionImpl
    extends MapWrapper
    implements BitcoindRpcClient.RawTransaction {
        public RawTransactionImpl(Map<String, Object> tx) {
            super(tx);
        }

        @Override
        public String hex() {
            return this.mapStr("hex");
        }

        @Override
        public String txId() {
            return this.mapStr("txid");
        }

        @Override
        public int version() {
            return this.mapInt("version");
        }

        @Override
        public long lockTime() {
            return this.mapLong("locktime");
        }

        @Override
        public List<BitcoindRpcClient.RawTransaction.In> vIn() {
            final List vIn = (List)this.m.get("vin");
            return new AbstractList<BitcoindRpcClient.RawTransaction.In>(){

                @Override
                public BitcoindRpcClient.RawTransaction.In get(int index) {
                    return new InImpl((Map)vIn.get(index));
                }

                @Override
                public int size() {
                    return vIn.size();
                }
            };
        }

        @Override
        public List<BitcoindRpcClient.RawTransaction.Out> vOut() {
            final List vOut = (List)this.m.get("vout");
            return new AbstractList<BitcoindRpcClient.RawTransaction.Out>(){

                @Override
                public BitcoindRpcClient.RawTransaction.Out get(int index) {
                    return new OutImpl((Map)vOut.get(index));
                }

                @Override
                public int size() {
                    return vOut.size();
                }
            };
        }

        @Override
        public String blockHash() {
            return this.mapStr("blockhash");
        }

        @Override
        public int confirmations() {
            return this.mapInt("confirmations");
        }

        @Override
        public Date time() {
            return this.mapCTime("time");
        }

        @Override
        public Date blocktime() {
            return this.mapCTime("blocktime");
        }

        private class OutImpl
        extends MapWrapper
        implements BitcoindRpcClient.RawTransaction.Out {
            public OutImpl(Map m) {
                super(m);
            }

            @Override
            public double value() {
                return this.mapDouble("value");
            }

            @Override
            public int n() {
                return this.mapInt("n");
            }

            @Override
            public BitcoindRpcClient.RawTransaction.Out.ScriptPubKey scriptPubKey() {
                return new ScriptPubKeyImpl((Map)this.m.get("scriptPubKey"));
            }

            @Override
            public BitcoindRpcClient.TxInput toInput() {
                return new BitcoindRpcClient.BasicTxInput(this.transaction().txId(), this.n());
            }

            @Override
            public BitcoindRpcClient.RawTransaction transaction() {
                return RawTransactionImpl.this;
            }

            private class ScriptPubKeyImpl
            extends MapWrapper
            implements BitcoindRpcClient.RawTransaction.Out.ScriptPubKey {
                public ScriptPubKeyImpl(Map m) {
                    super(m);
                }

                @Override
                public String asm() {
                    return this.mapStr("asm");
                }

                @Override
                public String hex() {
                    return this.mapStr("hex");
                }

                @Override
                public int reqSigs() {
                    return this.mapInt("reqSigs");
                }

                @Override
                public String type() {
                    return this.mapStr(this.type());
                }

                @Override
                public List<String> addresses() {
                    return (List)this.m.get("addresses");
                }
            }
        }

        private class InImpl
        extends MapWrapper
        implements BitcoindRpcClient.RawTransaction.In {
            public InImpl(Map m) {
                super(m);
            }

            @Override
            public String txid() {
                return this.mapStr("txid");
            }

            @Override
            public int vout() {
                return this.mapInt("vout");
            }

            @Override
            public Map<String, Object> scriptSig() {
                return (Map)this.m.get("scriptSig");
            }

            @Override
            public long sequence() {
                return this.mapLong("sequence");
            }

            @Override
            public BitcoindRpcClient.RawTransaction getTransaction() {
                try {
                    return BitcoinJSONRPCClient.this.getRawTransaction(this.mapStr("txid"));
                }
                catch (BitcoinRpcException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public BitcoindRpcClient.RawTransaction.Out getTransactionOutput() {
                return this.getTransaction().vOut().get(this.mapInt("vout"));
            }
        }
    }

    private class BlockMapWrapper
    extends MapWrapper
    implements BitcoindRpcClient.Block {
        public BlockMapWrapper(Map m) {
            super(m);
        }

        @Override
        public String hash() {
            return this.mapStr("hash");
        }

        @Override
        public int confirmations() {
            return this.mapInt("confirmations");
        }

        @Override
        public int size() {
            return this.mapInt("size");
        }

        @Override
        public int height() {
            return this.mapInt("height");
        }

        @Override
        public int version() {
            return this.mapInt("version");
        }

        @Override
        public String merkleRoot() {
            return this.mapStr("merkleroot");
        }

        @Override
        public String chainwork() {
            return this.mapStr("chainwork");
        }

        @Override
        public List<String> tx() {
            return (List)this.m.get("tx");
        }

        @Override
        public Date time() {
            return this.mapCTime("time");
        }

        @Override
        public long nonce() {
            return this.mapLong("nonce");
        }

        @Override
        public String bits() {
            return this.mapStr("bits");
        }

        @Override
        public double difficulty() {
            return this.mapDouble("difficulty");
        }

        @Override
        public String previousHash() {
            return this.mapStr("previousblockhash");
        }

        @Override
        public String nextHash() {
            return this.mapStr("nextblockhash");
        }

        @Override
        public BitcoindRpcClient.Block previous() throws BitcoinRpcException {
            if (!this.m.containsKey("previousblockhash")) {
                return null;
            }
            return BitcoinJSONRPCClient.this.getBlock(this.previousHash());
        }

        @Override
        public BitcoindRpcClient.Block next() throws BitcoinRpcException {
            if (!this.m.containsKey("nextblockhash")) {
                return null;
            }
            return BitcoinJSONRPCClient.this.getBlock(this.nextHash());
        }
    }

    private class BlockChainInfoMapWrapper
    extends MapWrapper
    implements BitcoindRpcClient.BlockChainInfo {
        public BlockChainInfoMapWrapper(Map m) {
            super(m);
        }

        @Override
        public String chain() {
            return this.mapStr("chain");
        }

        @Override
        public int blocks() {
            return this.mapInt("blocks");
        }

        @Override
        public String bestBlockHash() {
            return this.mapStr("bestblockhash");
        }

        @Override
        public double difficulty() {
            return this.mapDouble("difficulty");
        }

        @Override
        public double verificationProgress() {
            return this.mapDouble("verificationprogress");
        }

        @Override
        public String chainWork() {
            return this.mapStr("chainwork");
        }
    }
}

