/*
 * Decompiled with CFR 0.152.
 */
package wf.bitcoin.javabitcoindrpcclient;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import wf.bitcoin.krotjson.HexCoder;

class MapWrapper {
    public final Map<String, ?> m;

    public MapWrapper(Map<String, ?> m) {
        this.m = m;
    }

    public Boolean mapBool(String key) {
        return MapWrapper.mapBool(this.m, key);
    }

    public Integer mapInt(String key) {
        return MapWrapper.mapInt(this.m, key);
    }

    public Long mapLong(String key) {
        return MapWrapper.mapLong(this.m, key);
    }

    public String mapStr(String key) {
        return MapWrapper.mapStr(this.m, key);
    }

    public Date mapCTime(String key) {
        return MapWrapper.mapCTime(this.m, key);
    }

    public BigDecimal mapBigDecimal(String key) {
        return MapWrapper.mapBigDecimal(this.m, key);
    }

    public byte[] mapHex(String key) {
        return MapWrapper.mapHex(this.m, key);
    }

    public static Boolean mapBool(Map<String, ?> m, String key) {
        Object val = m.get(key);
        if (!(val instanceof Boolean)) {
            return null;
        }
        return (Boolean)val;
    }

    public static BigDecimal mapBigDecimal(Map<String, ?> m, String key) {
        Object val = m.get(key);
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        String strVal = MapWrapper.mapStr(m, key);
        if (strVal == null) {
            return null;
        }
        return new BigDecimal(strVal);
    }

    public static Integer mapInt(Map<String, ?> m, String key) {
        Object val = m.get(key);
        if (!(val instanceof Number)) {
            return null;
        }
        return ((Number)val).intValue();
    }

    public static Long mapLong(Map<String, ?> m, String key) {
        Object val = m.get(key);
        if (!(val instanceof Number)) {
            return null;
        }
        return ((Number)val).longValue();
    }

    public static String mapStr(Map<String, ?> m, String key) {
        Object val = m.get(key);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    public static Date mapCTime(Map<String, ?> m, String key) {
        Long longVal = MapWrapper.mapLong(m, key);
        if (longVal == null) {
            return null;
        }
        return new Date(longVal * 1000L);
    }

    public static byte[] mapHex(Map<String, ?> m, String key) {
        String strVal = MapWrapper.mapStr(m, key);
        if (strVal == null) {
            return null;
        }
        return HexCoder.decode(strVal);
    }

    public String toString() {
        return String.valueOf(this.m);
    }
}

