package app.microkit.sdk

import kotlinx.serialization.json.*

class FeatureItem: Item {
    constructor(value: JsonElement, name: String): super(value, name)

     override fun getValue (user: HashMap<String, Any>): Any {
            val featur = mapOf("value" to this.item["value"], "type" to this.item["type"], "targeting_groups" to this.item["targeting_groups"])
            val features = mapOf(this.name to featur);
            val data = mapOf("user" to Json.encodeToJsonElement(user.mapValues {transformToJsonElement(it.value)}), "features" to Json.encodeToJsonElement(features));

            val res = HttpClient.makeRequest("get_user_data","get_feature_by_user", data as HashMap<String, Any>)
            val resMap = Json.parseToJsonElement(res).jsonObject.toMap();
            val resFeatures = resMap["features"];
            val resFeaturesMap = Json.parseToJsonElement(resFeatures.toString()).jsonObject.toMap();
            val resFeature = resFeaturesMap[this.name];
            val resFeatureMap = Json.parseToJsonElement(resFeature.toString()).jsonObject.toMap();
            return this.getItemValue(resFeatureMap);

    }

    override fun getBoolValue (user: HashMap<String, Any>): Boolean {
        return this.getValue(user) as Boolean;
    }

    override fun getStringValue (user: HashMap<String, Any>): String {
        return this.getValue(user) as String;
    }

    override fun getIntValue (user: HashMap<String, Any>): Int {
        return (this.getValue(user) as Double).toInt();
    }

    override fun getDoubleValue (user: HashMap<String, Any>): Double {
        return this.getValue(user) as Double;
    }
}