package app.microkit.sdk;

import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.jsonObject
import kotlin.jvm.JvmField

abstract class Leaf {
    abstract fun update (item: Any, inti: Boolean = false)
    abstract fun getValue(): Any
    @JvmField
    public val change: Publisher  = Publisher();
}

class Group: Leaf {
    private var updated = false
    val type: String
    private val items: HashMap<String, Leaf> = HashMap();

    constructor(type: String ,items: Any) {
        this.type = type;
        this.update(items)
    }

    override fun update (items: Any, init: Boolean) {
        (items as Map<String, JsonElement>).forEach { (key, item) -> this.createLeafs(key, item, init) }
    }

    private fun createLeafs (key: String, json: JsonElement, init: Boolean = false) {
        val item = json.jsonObject.toMap();
        if (key in this.items) {
            if ((!("type" in item) && !("value" in item))) {
                this.items[key]!!.update(item)
            } else {
                this.items[key]!!.update(json)
            }
        } else {
            if (!init) {
                this.updated = true;
            }
            this.items[key] = this.setNewVal(json, key);
            this.items[key]!!.change.subscribe(fun(currentValue: Any, prevValue: Any) {
                this.updated = true;
            });
            if (this.updated) {
//                    this.change.publish(this.getValue(), prevValue)
                this.updated = false
            }
        }
    }

    fun getGroup (groupName: String): Group {
        if (items[groupName] is Group) {
            return items[groupName] as Group;
        } else {
            throw Exception("$groupName Type is not Group!!!")
        }
    }

    fun getItem (itemName: String): Item {
        if (items[itemName] is Item) {
            return items[itemName] as Item;
        } else {
            throw Exception("$itemName Type is not Item!!!")
        }
    }

    override fun getValue(): Any {
       return this.items.mapValues { it.value.getValue() };
    }

    private fun setNewVal (item: JsonElement, name: String): Leaf {

        val jsonMap = item.jsonObject.toMap()
        if ((!("type" in jsonMap) && !("value" in jsonMap))) {
            return Group(this.type, jsonMap);
        } else if (this.type == "config") {
            return  ConfigItem(item, name);
        } else if (this.type == "features") {
            return  FeatureItem(item, name);
        }
        return item as Leaf;

    }


}