/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.commons.service;

import cn.eppdev.jee.commons.dao.BasicDao;
import cn.eppdev.jee.commons.entity.BasicEntity;
import cn.eppdev.jee.commons.param.BasicParam;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class BasicService<T extends BasicEntity, P extends BasicParam> {
    private static Logger logger = LoggerFactory.getLogger(BasicService.class);
    public static final Integer DEL_FLAG_NORMAL = 0;

    public T get(String id) {
        return this.getDao().get(id);
    }

    @Transactional(readOnly=false)
    public int delete(String id) {
        BasicEntity entity = new BasicEntity();
        entity.setId(id);
        entity.setUpdateDate(new Date());
        return this.getDao().delete(entity);
    }

    @Transactional(readOnly=false)
    public int delete(String id, String userId) {
        BasicEntity entity = new BasicEntity();
        entity.setId(id);
        entity.setUpdateDate(new Date());
        entity.setUpdateBy(userId);
        return this.getDao().delete(entity);
    }

    public int deleteBy(P param) {
        return this.getDao().deleteBy(param);
    }

    @Transactional(readOnly=false)
    public int save(T entity) {
        logger.debug("entity: {}", entity);
        if (!this.exists(entity)) {
            if (((BasicEntity)entity).getId() == null || ((BasicEntity)entity).getId().trim().length() == 0) {
                return this.insert(entity);
            }
            return this.update(entity);
        }
        return 0;
    }

    @Transactional(readOnly=false)
    public int insert(T entity) {
        logger.debug("entity: {}", entity);
        if (!this.exists(entity)) {
            this._init(entity);
            return this.getDao().insert(entity);
        }
        return 0;
    }

    public int update(T entity) {
        logger.debug("entity:{}", entity);
        if (!this.exists(entity)) {
            ((BasicEntity)entity).setUpdateDate(new Date());
            return this.getDao().update(entity);
        }
        return 0;
    }

    private void _init(T entity) {
        Date date = new Date();
        if (((BasicEntity)entity).getId() == null || ((BasicEntity)entity).getId().trim().length() == 0) {
            ((BasicEntity)entity).setId(UUID.randomUUID().toString().replace("-", ""));
        }
        ((BasicEntity)entity).setCreateDate(date);
        ((BasicEntity)entity).setUpdateDate(date);
        ((BasicEntity)entity).setDelFlag(DEL_FLAG_NORMAL);
        this.customeInit(entity);
    }

    public PageInfo<T> listAll() {
        return new PageInfo(this.getDao().list(null));
    }

    public PageInfo<T> list(P param) {
        return new PageInfo(this.getDao().list(param));
    }

    public abstract boolean exists(T var1);

    public abstract void customeInit(T var1);

    public abstract BasicDao<T, P> getDao();
}

