/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.service;

import cn.eppdev.jee.conf.entity.EppdevConf;
import cn.eppdev.jee.conf.service.auto._EppdevConfService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Service;

@Service
public class EppdevConfService
extends _EppdevConfService {
    static ConcurrentHashMap<String, String> CACHED_MAP = new ConcurrentHashMap();

    @Override
    public void customeInit(EppdevConf entity) {
    }

    public String getConf(String key) {
        return this.getAllConf().get(key);
    }

    public Map<String, String> getAllConf() {
        if (((ConcurrentHashMap.CollectionView)((Object)CACHED_MAP.keySet())).size() == 0) {
            for (EppdevConf conf : this.listAll().getList()) {
                CACHED_MAP.put(conf.getConfName(), conf.getConfValue());
            }
        }
        return CACHED_MAP;
    }

    public String getDbType() {
        return this.getAllConf().get("DB_TYPE");
    }

    public String getProjectPath() {
        return this.getAllConf().get("PROJECT_PATH");
    }

    public String getBasicPackageName() {
        return this.getAllConf().get("BASIC_PACKAGE_NAME");
    }

    public String getGitPath() {
        return this.getAllConf().get("GIT_PATH");
    }

    public String getGitAutoPush() {
        return this.getAllConf().get("GIT_AUTO_PUSH");
    }

    public String getGitUseNewBranch() {
        return this.getAllConf().get("GIT_USE_NEW_BRANCH");
    }

    public String getGitMainBranchName() {
        return this.getAllConf().get("GIT_MAIN_BRANCH_NAME");
    }

    @Override
    public int update(EppdevConf entity) {
        int cnt = super.update(entity);
        if (cnt > 0) {
            CACHED_MAP.put(entity.getConfName(), entity.getConfValue());
        }
        return cnt;
    }
}

