/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVPowerfulUtils;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVRuntimeException;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.SendCallback;
import com.avos.avoscloud.internal.InternalConfigurationController;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class AVPush {
    private static final String INSTALLATIONTAG = "_Installation";
    private static final String deviceTypeTag = "deviceType";
    private static final Set<String> DEVICE_TYPES = new HashSet<String>();
    private final Set<String> channelSet = new HashSet<String>();
    private AVQuery<? extends AVObject> pushQuery;
    private String cql;
    private long expirationTime;
    private long expirationTimeInterval;
    private final Set<String> pushTarget;
    private final Map<String, Object> pushData = new HashMap<String, Object>();
    private volatile AVObject notification;
    private Date pushDate = null;
    private boolean production = true;

    public AVPush() {
        this.pushTarget = new HashSet<String>(DEVICE_TYPES);
        this.pushQuery = new AVQuery(INSTALLATIONTAG);
    }

    public Set<String> getChannelSet() {
        return this.channelSet;
    }

    public AVObject getNotification() {
        return this.notification;
    }

    public AVQuery getPushQuery() {
        return this.pushQuery;
    }

    public Date getPushDate() {
        return this.pushDate;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public long getExpirationTimeInterval() {
        return this.expirationTimeInterval;
    }

    public Set<String> getPushTarget() {
        return this.pushTarget;
    }

    public Map<String, Object> getPushData() {
        return this.pushData;
    }

    public void clearExpiration() {
        this.expirationTime = 0L;
        this.expirationTimeInterval = 0L;
    }

    public void send() {
        this.sendInBackground(true, null);
    }

    static void sendDataInBackground(JSONObject data, AVQuery<? extends AVObject> query) throws AVException {
        if (!query.getClassName().equals(INSTALLATIONTAG)) {
            throw new AVException(-1, "only installation query is valid");
        }
        AVPush push = new AVPush();
        push.setData(data);
        push.setQuery(query);
        push.sendInBackground();
    }

    public static void sendDataInBackground(JSONObject data, AVQuery<? extends AVObject> query, SendCallback callback) {
        if (!query.getClassName().equals(INSTALLATIONTAG) && callback != null) {
            callback.done(new AVException(-1, "only installation query is valid"));
        }
        AVPush push = new AVPush();
        push.setData(data);
        push.setQuery(query);
        push.sendInBackground(false, callback);
    }

    public void sendInBackground() {
        this.sendInBackground(false, null);
    }

    public void sendInBackground(SendCallback callback) {
        this.sendInBackground(false, callback);
    }

    private Map<String, Object> pushChannelsData() {
        return AVUtils.createStringObjectMap((String)"channels", this.channelSet);
    }

    private Map<String, Object> postDataMap() throws AVException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.pushQuery != null) {
            if (this.pushTarget.size() == 0) {
                this.pushQuery.whereNotContainedIn(deviceTypeTag, DEVICE_TYPES);
            } else if (this.pushTarget.size() == 1) {
                this.pushQuery.whereEqualTo(deviceTypeTag, this.pushTarget.toArray()[0]);
            }
            Map pushParameters = this.pushQuery.assembleParameters();
            if (pushParameters.keySet().size() > 0 && !AVUtils.isBlankString((String)this.cql)) {
                throw new IllegalStateException("You can't use AVQuery and Cloud query at the same time.");
            }
            for (String k : pushParameters.keySet()) {
                map.put(k, JSON.parse((String)((String)pushParameters.get(k))));
            }
        }
        if (!AVUtils.isBlankString((String)this.cql)) {
            map.put("cql", this.cql);
        }
        if (this.channelSet.size() > 0) {
            map.putAll(this.pushChannelsData());
        }
        if (this.expirationTime > 0L) {
            map.put("expiration_time", this.expirationDateTime());
        }
        if (this.expirationTimeInterval > 0L) {
            map.put("push_time", AVUtils.stringFromDate((Date)new Date()));
            map.put("expiration_interval", new Long(this.expirationTimeInterval));
        }
        if (this.pushDate != null) {
            map.put("push_time", AVUtils.stringFromDate((Date)this.pushDate));
        }
        if (!this.production) {
            map.put("prod", "dev");
        }
        map.putAll(this.pushData);
        return map;
    }

    private void sendInBackground(boolean sync, SendCallback callback) {
        final SendCallback internalCallback = callback;
        String path = "push";
        try {
            Map<String, Object> map = this.postDataMap();
            String jsonString = AVUtils.jsonStringFromMapWithNull(map);
            PaasClient.storageInstance().postObject(path, jsonString, sync, new GenericObjectCallback(){

                public void onSuccess(String content, AVException e) {
                    AVPush.this.notification = new AVObject("_Notification");
                    AVUtils.copyPropertiesFromJsonStringToAVObject((String)content, (AVObject)AVPush.this.notification);
                    if (internalCallback != null) {
                        internalCallback.internalDone(null);
                    }
                }

                public void onFailure(Throwable error, String content) {
                    if (internalCallback != null) {
                        internalCallback.internalDone(AVErrorUtils.createException((Throwable)error, (String)content));
                    }
                }
            });
        }
        catch (AVException e) {
            if (callback != null) {
                callback.internalDone(e);
            }
            LogUtil.log.e((String)"AVPush sent exception", (Exception)((Object)e));
        }
    }

    public static void sendMessageInBackground(String message, AVQuery<? extends AVObject> query) {
        if (!query.getClassName().equals(INSTALLATIONTAG)) {
            InternalConfigurationController.globalInstance().getInternalLogger().e(AVPush.class.getSimpleName(), "only installation query is valid");
            return;
        }
        AVPush push = new AVPush();
        push.setMessage(message);
        push.setQuery(query);
        push.sendInBackground(false, null);
    }

    public static void sendMessageInBackground(String message, AVQuery<? extends AVObject> query, SendCallback callback) {
        if (!query.getClassName().equals(INSTALLATIONTAG) && callback != null) {
            callback.done(new AVException(-1, "only installation query is valid"));
        }
        AVPush push = new AVPush();
        push.setMessage(message);
        push.setQuery(query);
        push.sendInBackground(false, callback);
    }

    public void setChannel(String channel) {
        this.channelSet.clear();
        this.channelSet.add(channel);
    }

    public void setChannels(Collection<String> channels) {
        this.channelSet.clear();
        this.channelSet.addAll(channels);
    }

    public void setData(Map<String, Object> data) {
        this.pushData.put("data", data);
    }

    public void setData(JSONObject data) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterator iter = data.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = data.get(key);
                map.put(key, value);
            }
            this.pushData.put("data", map);
        }
        catch (Exception exception) {
            throw new AVRuntimeException((Throwable)exception);
        }
    }

    private Date expirationDateTime() {
        return new Date(this.expirationTime);
    }

    public void setPushDate(Date date) {
        this.pushDate = date;
    }

    public void setExpirationTime(long time) {
        this.expirationTime = time;
    }

    public void setExpirationTimeInterval(long timeInterval) {
        this.expirationTimeInterval = timeInterval;
    }

    public void setMessage(String message) {
        this.pushData.clear();
        Map map = AVUtils.createStringObjectMap((String)"alert", (Object)message);
        this.pushData.put("data", map);
    }

    public void setPushToAndroid(boolean pushToAndroid) {
        if (pushToAndroid) {
            this.pushTarget.add("android");
        } else {
            this.pushTarget.remove("android");
        }
    }

    public void setPushToIOS(boolean pushToIOS) {
        if (pushToIOS) {
            this.pushTarget.add("ios");
        } else {
            this.pushTarget.remove("ios");
        }
    }

    public void setPushToWindowsPhone(boolean pushToWP) {
        if (pushToWP) {
            this.pushTarget.add("wp");
        } else {
            this.pushTarget.remove("wp");
        }
    }

    public void setQuery(AVQuery<? extends AVObject> query) {
        this.pushQuery = query;
    }

    public void setCloudQuery(String cql) {
        this.cql = cql;
    }

    public boolean getProductionMode() {
        return this.production;
    }

    public void setProductionMode(boolean production) {
        this.production = production;
    }

    static {
        DEVICE_TYPES.add("android");
        DEVICE_TYPES.add("ios");
        AVPowerfulUtils.createSettings((String)AVPush.class.getSimpleName(), (String)"push", (String)"");
    }
}

