package cn.openjava.basic.format.advice;


import cn.openjava.basic.format.exception.BaseException;
import cn.openjava.basic.format.exception.OpenJavaException;
import cn.openjava.basic.format.vo.Result;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ControllerExceptionAdvice {
    /**
     * 日志
     */
    private static Log log = LogFactory.getLog(ControllerExceptionAdvice.class);


    @ExceptionHandler({BaseException.class, OpenJavaException.class})
    public ResponseEntity handleBaseException(BaseException e) {
        return new ResponseEntity<>(Result.message(e.getType(), e.getCode(), e.getMessage()), e.getHttpStatus());
    }

}
