package cn.openjava.basic.format.message;


import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.experimental.Accessors;

/**
 * 异常会话
 */
@Getter
@Accessors(fluent = true)
@AllArgsConstructor
public enum SystemMessage implements IMessage {
    /**
     * 消息
     */
    INFO(MessageType.INFO, 200, "{0}"),
    /**
     * 成功
     */
    SUCCESS(MessageType.SUCCESS, 200, "成功"),

    /**
     * 警告
     */
    NORMAL_WARNING(MessageType.WARNING, 500, "普通警告"),

    /**
     * 错误
     */
    NORMAL_ERROR(MessageType.ERROR, 500, "普通错误"),

    /**
     * 系统异常
     */
    EXCEPTION(MessageType.ERROR, 600, "系统异常"),
    /**
     * 参数解析异常
     */
    PARAM_PARSE_EXCEPTION(MessageType.ERROR, 601, "参数解析异常"),
    /**
     * 空指针异常
     */
    NULL_POINTER_EXCEPTION(MessageType.ERROR, 602, "空指针异常"),
    /**
     * 类型异常
     */
    RESULT_NOT_ALLOWED_EXCEPTION(MessageType.ERROR, 603, "不允许返回此类型"),
    /**
     * 异常抛出
     */
    THROWABLE_EXCEPTION(MessageType.ERROR, 605, "异常抛出"),
    /**
     * 数字转换异常
     */
    NUMBER_CONVERT_EXCEPTION(MessageType.ERROR, 606, "数字转换异常"),
    /**
     * 参数类型不匹配异常
     */
    METHOD_ARGUMENT_TYPE_MISMATCH_EXCEPTION(MessageType.ERROR, 607, "参数类型不匹配异常"),
    /**
     * 反射处理异常
     */
    REFLECT_HANDLER_EXCEPTION(MessageType.ERROR, 608, "反射处理异常"),
    /**
     * 文件下载异常
     */
    DOWNLOAD_FILE_EXCEPTION(MessageType.ERROR, 609, "文件下载异常"),
    /**
     * 用户自定义异常
     */
    USER_DEFINED_EXCEPTION(MessageType.ERROR, 699, "{0}");
    /**
     * 类型
     */
    private final MessageType type;
    /**
     * 消息编码
     */
    private final int code;
    /**
     * 消息内容
     */
    private final String message;
}
