/*
 * Decompiled with CFR 0.152.
 */
package cn.openjava.basic.format.vo;

import cn.hutool.core.util.StrUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Dict {
    private String text;
    private String value;

    public static <S extends Enum> List<Dict> convertEnumToDict(Class<S> clazz) {
        ArrayList<Dict> items = new ArrayList<Dict>();
        try {
            S[] enumConstants;
            for (S constant : enumConstants = clazz.getEnumConstants()) {
                Object value;
                Object text;
                try {
                    text = clazz.getDeclaredMethod("getText", new Class[0]).invoke(constant, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    text = constant;
                }
                try {
                    value = clazz.getDeclaredMethod("getValue", new Class[0]).invoke(constant, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    value = constant;
                }
                items.add(new Dict(StrUtil.toString(value), StrUtil.toString(text)));
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return items;
    }

    public static Map<String, List<Dict>> convertEnumToDicts(String key, Class clazz) {
        HashMap<String, List<Dict>> result = new HashMap<String, List<Dict>>();
        if (StrUtil.isBlank((CharSequence)key) || clazz == null) {
            return result;
        }
        result.put(key, Dict.convertEnumToDict(clazz));
        return result;
    }

    public static Map<String, List<Dict>> convertEnumToDicts(Class clazz) {
        HashMap<String, List<Dict>> result = new HashMap<String, List<Dict>>();
        if (clazz == null) {
            return result;
        }
        result.put(StrUtil.lowerFirst((CharSequence)clazz.getSimpleName()), Dict.convertEnumToDict(clazz));
        return result;
    }

    public static Map<String, List<Dict>> convertEnumsToDicts(String[] keys, Class[] classes) {
        HashMap<String, List<Dict>> result = new HashMap<String, List<Dict>>();
        if (keys == null || classes == null || keys.length != classes.length) {
            return result;
        }
        for (int i = 0; i < keys.length; ++i) {
            result.put(keys[i], Dict.convertEnumToDict(classes[i]));
        }
        return result;
    }

    public static Map<String, List<Dict>> convertEnumsToDicts(Class[] classes) {
        HashMap<String, List<Dict>> result = new HashMap<String, List<Dict>>();
        for (Class clazz : classes) {
            result.put(StrUtil.lowerFirst((CharSequence)clazz.getSimpleName()), Dict.convertEnumToDict(clazz));
        }
        return result;
    }

    public String getText() {
        return this.text;
    }

    public String getValue() {
        return this.value;
    }

    public Dict setText(String text) {
        this.text = text;
        return this;
    }

    public Dict setValue(String value) {
        this.value = value;
        return this;
    }

    public String toString() {
        return "Dict(text=" + this.getText() + ", value=" + this.getValue() + ")";
    }

    public Dict() {
    }

    public Dict(String text, String value) {
        this.text = text;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dict)) {
            return false;
        }
        Dict other = (Dict)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Dict;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

