/*
 * Decompiled with CFR 0.152.
 */
package co.dapi;

import co.dapi.Config;
import co.dapi.DapiRequest;
import co.dapi.response.ExchangeTokenResponse;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;

public class Auth {
    private final Config config;

    public Auth(Config config) {
        this.config = config;
    }

    public ExchangeTokenResponse exchangeToken(String accessCode, String connectionID) throws IOException {
        ExchangeTokenRequest body = new ExchangeTokenRequest(this.config.getAppSecret(), accessCode, connectionID);
        String bodyJson = DapiRequest.jsonAgent.toJson((Object)body, ExchangeTokenRequest.class);
        String respJson = DapiRequest.Do(bodyJson, "https://api.dapi.com/v2" + "/auth/ExchangeToken");
        ExchangeTokenResponse resp = null;
        try {
            resp = (ExchangeTokenResponse)DapiRequest.jsonAgent.fromJson(respJson, ExchangeTokenResponse.class);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        if (resp == null || resp.getStatus() == null && !resp.getType().isPresent()) {
            return new ExchangeTokenResponse("UNEXPECTED_RESPONSE", "Unexpected response body");
        }
        return resp;
    }

    private static class ExchangeTokenRequest {
        private final String action = "/auth/ExchangeToken";
        private final String appSecret;
        private final String accessCode;
        private final String connectionID;

        public ExchangeTokenRequest(String appSecret, String accessCode, String connectionID) {
            this.appSecret = appSecret;
            this.accessCode = accessCode;
            this.connectionID = connectionID;
        }
    }
}

