/*
 * Decompiled with CFR 0.152.
 */
package io.ipdata.client;

import feign.Client;
import io.ipdata.client.CacheConfigBuilder;
import io.ipdata.client.service.CacheConfig;
import io.ipdata.client.service.IpdataService;
import io.ipdata.client.service.IpdataServiceBuilder;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;

public final class Ipdata {
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    private Ipdata() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Builder {
        private String key;
        private URL url;
        private CacheConfig cacheConfig;
        private Logger logger;
        private Client feignClient;

        public Builder noCache() {
            this.cacheConfig = null;
            return this;
        }

        public Builder withDefaultCache() {
            return new CacheConfigBuilder(this).maxSize(1024L).timeout(4, TimeUnit.HOURS).registerCacheConfig();
        }

        public CacheConfigBuilder withCache() {
            return new CacheConfigBuilder(this);
        }

        public IpdataService get() {
            if (this.key == null) {
                throw new IllegalArgumentException("Key can't be null");
            }
            if (this.url == null) {
                throw new IllegalArgumentException("Target URL can't be null");
            }
            return IpdataServiceBuilder.of(this.url, this.key, this.cacheConfig, this.logger, this.feignClient).build();
        }

        @Generated
        private Builder() {
        }

        @Generated
        public Builder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public Builder url(URL url) {
            this.url = url;
            return this;
        }

        @Generated
        Builder cacheConfig(CacheConfig cacheConfig) {
            this.cacheConfig = cacheConfig;
            return this;
        }

        @Generated
        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        @Generated
        public Builder feignClient(Client feignClient) {
            this.feignClient = feignClient;
            return this;
        }
    }
}

