/*
 * Decompiled with CFR 0.152.
 */
package io.ipdata.client.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.LoadingCache;
import io.ipdata.client.error.IpdataException;
import io.ipdata.client.model.AsnModel;
import io.ipdata.client.model.Currency;
import io.ipdata.client.model.IpdataModel;
import io.ipdata.client.model.ThreatModel;
import io.ipdata.client.model.TimeZone;
import io.ipdata.client.service.HashPair;
import io.ipdata.client.service.IpdataInternalClient;
import io.ipdata.client.service.IpdataInternalSingleFieldClient;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

@VisibleForTesting
public class CachingInternalClient
implements IpdataInternalClient,
IpdataInternalSingleFieldClient {
    private int expiry;
    private TimeUnit unit;
    private Long maxSize;
    private IpdataInternalClient ipdataInternalClient;
    private IpdataInternalSingleFieldClient ipdataInternalSingleFieldClient;
    private LoadingCache<String, IpdataModel> ipdataCache;
    private LoadingCache<HashPair<String, String>, IpdataModel> fieldsCache;
    private LoadingCache<String, AsnModel> asnCache;
    private LoadingCache<String, TimeZone> tzCache;
    private LoadingCache<String, Currency> currencyCache;
    private LoadingCache<String, ThreatModel> threatCache;

    @Override
    public IpdataModel getFields(String ip, String fields) throws IpdataException {
        try {
            return (IpdataModel)this.fieldsCache.get(HashPair.of(ip, fields));
        }
        catch (ExecutionException e) {
            throw new IpdataException(e.getMessage(), e);
        }
    }

    @Override
    public AsnModel asn(String ip) throws IpdataException {
        try {
            return (AsnModel)this.asnCache.get((Object)ip);
        }
        catch (ExecutionException e) {
            throw new IpdataException(e.getMessage(), e);
        }
    }

    @Override
    public TimeZone timeZone(String ip) throws IpdataException {
        try {
            return (TimeZone)this.tzCache.get((Object)ip);
        }
        catch (ExecutionException e) {
            throw new IpdataException(e.getMessage(), e);
        }
    }

    @Override
    public Currency currency(String ip) throws IpdataException {
        try {
            return (Currency)this.currencyCache.get((Object)ip);
        }
        catch (ExecutionException e) {
            throw new IpdataException(e.getMessage(), e);
        }
    }

    @Override
    public ThreatModel threat(String ip) throws IpdataException {
        try {
            return (ThreatModel)this.threatCache.get((Object)ip);
        }
        catch (ExecutionException e) {
            throw new IpdataException(e.getMessage(), e);
        }
    }

    @Override
    public IpdataModel ipdata(String ip) throws IpdataException {
        try {
            return (IpdataModel)this.ipdataCache.get((Object)ip);
        }
        catch (ExecutionException e) {
            throw new IpdataException(e.getMessage(), e);
        }
    }

    @Override
    public List<IpdataModel> bulk(List<String> ips) throws IpdataException {
        return this.ipdataInternalClient.bulk(ips);
    }

    IpdataInternalSingleFieldClient getIpdataInternalSingleFieldClient() {
        return this.ipdataInternalSingleFieldClient;
    }

    @Generated
    private static int $default$expiry() {
        return 4;
    }

    @Generated
    private static TimeUnit $default$unit() {
        return TimeUnit.HOURS;
    }

    @Generated
    private static Long $default$maxSize() {
        return Long.MAX_VALUE;
    }

    @Generated
    CachingInternalClient(int expiry, TimeUnit unit, Long maxSize, IpdataInternalClient ipdataInternalClient, IpdataInternalSingleFieldClient ipdataInternalSingleFieldClient, LoadingCache<String, IpdataModel> ipdataCache, LoadingCache<HashPair<String, String>, IpdataModel> fieldsCache, LoadingCache<String, AsnModel> asnCache, LoadingCache<String, TimeZone> tzCache, LoadingCache<String, Currency> currencyCache, LoadingCache<String, ThreatModel> threatCache) {
        this.expiry = expiry;
        this.unit = unit;
        this.maxSize = maxSize;
        this.ipdataInternalClient = ipdataInternalClient;
        this.ipdataInternalSingleFieldClient = ipdataInternalSingleFieldClient;
        this.ipdataCache = ipdataCache;
        this.fieldsCache = fieldsCache;
        this.asnCache = asnCache;
        this.tzCache = tzCache;
        this.currencyCache = currencyCache;
        this.threatCache = threatCache;
    }

    @Generated
    public static CachingInternalClientBuilder builder() {
        return new CachingInternalClientBuilder();
    }

    @Override
    @Generated
    public String getIp(String ip) throws IpdataException {
        return this.getIpdataInternalSingleFieldClient().getIp(ip);
    }

    @Override
    @Generated
    public boolean isEu(String ip) throws IpdataException {
        return this.getIpdataInternalSingleFieldClient().isEu(ip);
    }

    @Override
    @Generated
    public String getCity(String ip) throws IpdataException {
        return this.getIpdataInternalSingleFieldClient().getCity(ip);
    }

    @Override
    @Generated
    public String getCountryName(String ip) throws IpdataException {
        return this.getIpdataInternalSingleFieldClient().getCountryName(ip);
    }

    @Override
    @Generated
    public String getCountryCode(String ip) throws IpdataException {
        return this.getIpdataInternalSingleFieldClient().getCountryCode(ip);
    }

    @Override
    @Generated
    public String getContinentCode(String ip) throws IpdataException {
        return this.getIpdataInternalSingleFieldClient().getContinentCode(ip);
    }

    @Override
    @Generated
    public double getLongitude(String ip) throws IpdataException {
        return this.getIpdataInternalSingleFieldClient().getLongitude(ip);
    }

    @Override
    @Generated
    public double getLatitude(String ip) throws IpdataException {
        return this.getIpdataInternalSingleFieldClient().getLatitude(ip);
    }

    @Override
    @Generated
    public String getOrganisation(String ip) throws IpdataException {
        return this.getIpdataInternalSingleFieldClient().getOrganisation(ip);
    }

    @Override
    @Generated
    public String getPostal(String ip) throws IpdataException {
        return this.getIpdataInternalSingleFieldClient().getPostal(ip);
    }

    @Override
    @Generated
    public String getCallingCode(String ip) throws IpdataException {
        return this.getIpdataInternalSingleFieldClient().getCallingCode(ip);
    }

    @Override
    @Generated
    public String getFlag(String ip) throws IpdataException {
        return this.getIpdataInternalSingleFieldClient().getFlag(ip);
    }

    @Override
    @Generated
    public String getEmojiFlag(String ip) throws IpdataException {
        return this.getIpdataInternalSingleFieldClient().getEmojiFlag(ip);
    }

    @Override
    @Generated
    public String getEmojiUnicode(String ip) throws IpdataException {
        return this.getIpdataInternalSingleFieldClient().getEmojiUnicode(ip);
    }

    @Generated
    public static class CachingInternalClientBuilder {
        @Generated
        private boolean expiry$set;
        @Generated
        private int expiry$value;
        @Generated
        private boolean unit$set;
        @Generated
        private TimeUnit unit$value;
        @Generated
        private boolean maxSize$set;
        @Generated
        private Long maxSize$value;
        @Generated
        private IpdataInternalClient ipdataInternalClient;
        @Generated
        private IpdataInternalSingleFieldClient ipdataInternalSingleFieldClient;
        @Generated
        private LoadingCache<String, IpdataModel> ipdataCache;
        @Generated
        private LoadingCache<HashPair<String, String>, IpdataModel> fieldsCache;
        @Generated
        private LoadingCache<String, AsnModel> asnCache;
        @Generated
        private LoadingCache<String, TimeZone> tzCache;
        @Generated
        private LoadingCache<String, Currency> currencyCache;
        @Generated
        private LoadingCache<String, ThreatModel> threatCache;

        @Generated
        CachingInternalClientBuilder() {
        }

        @Generated
        public CachingInternalClientBuilder expiry(int expiry) {
            this.expiry$value = expiry;
            this.expiry$set = true;
            return this;
        }

        @Generated
        public CachingInternalClientBuilder unit(TimeUnit unit) {
            this.unit$value = unit;
            this.unit$set = true;
            return this;
        }

        @Generated
        public CachingInternalClientBuilder maxSize(Long maxSize) {
            this.maxSize$value = maxSize;
            this.maxSize$set = true;
            return this;
        }

        @Generated
        public CachingInternalClientBuilder ipdataInternalClient(IpdataInternalClient ipdataInternalClient) {
            this.ipdataInternalClient = ipdataInternalClient;
            return this;
        }

        @Generated
        public CachingInternalClientBuilder ipdataInternalSingleFieldClient(IpdataInternalSingleFieldClient ipdataInternalSingleFieldClient) {
            this.ipdataInternalSingleFieldClient = ipdataInternalSingleFieldClient;
            return this;
        }

        @Generated
        public CachingInternalClientBuilder ipdataCache(LoadingCache<String, IpdataModel> ipdataCache) {
            this.ipdataCache = ipdataCache;
            return this;
        }

        @Generated
        public CachingInternalClientBuilder fieldsCache(LoadingCache<HashPair<String, String>, IpdataModel> fieldsCache) {
            this.fieldsCache = fieldsCache;
            return this;
        }

        @Generated
        public CachingInternalClientBuilder asnCache(LoadingCache<String, AsnModel> asnCache) {
            this.asnCache = asnCache;
            return this;
        }

        @Generated
        public CachingInternalClientBuilder tzCache(LoadingCache<String, TimeZone> tzCache) {
            this.tzCache = tzCache;
            return this;
        }

        @Generated
        public CachingInternalClientBuilder currencyCache(LoadingCache<String, Currency> currencyCache) {
            this.currencyCache = currencyCache;
            return this;
        }

        @Generated
        public CachingInternalClientBuilder threatCache(LoadingCache<String, ThreatModel> threatCache) {
            this.threatCache = threatCache;
            return this;
        }

        @Generated
        public CachingInternalClient build() {
            int expiry$value = this.expiry$value;
            if (!this.expiry$set) {
                expiry$value = CachingInternalClient.$default$expiry();
            }
            TimeUnit unit$value = this.unit$value;
            if (!this.unit$set) {
                unit$value = CachingInternalClient.$default$unit();
            }
            Long maxSize$value = this.maxSize$value;
            if (!this.maxSize$set) {
                maxSize$value = CachingInternalClient.$default$maxSize();
            }
            return new CachingInternalClient(expiry$value, unit$value, maxSize$value, this.ipdataInternalClient, this.ipdataInternalSingleFieldClient, this.ipdataCache, this.fieldsCache, this.asnCache, this.tzCache, this.currencyCache, this.threatCache);
        }

        @Generated
        public String toString() {
            return "CachingInternalClient.CachingInternalClientBuilder(expiry$value=" + this.expiry$value + ", unit$value=" + (Object)((Object)this.unit$value) + ", maxSize$value=" + this.maxSize$value + ", ipdataInternalClient=" + this.ipdataInternalClient + ", ipdataInternalSingleFieldClient=" + this.ipdataInternalSingleFieldClient + ", ipdataCache=" + this.ipdataCache + ", fieldsCache=" + this.fieldsCache + ", asnCache=" + this.asnCache + ", tzCache=" + this.tzCache + ", currencyCache=" + this.currencyCache + ", threatCache=" + this.threatCache + ")";
        }
    }

    private static interface DelegateExcludes {
        public AsnModel asn(String var1);

        public TimeZone timeZone(String var1);

        public Currency currency(String var1);

        public ThreatModel threat(String var1);
    }
}

