/*
 * Decompiled with CFR 0.152.
 */
package io.ipdata.client.service;

import com.google.common.io.CharStreams;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.io.InputStreamReader;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApiKeyRequestInterceptor
implements RequestInterceptor {
    @Generated
    private static final Logger log;
    private static final String API_KEY_PARAM = "api-key";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String JSON_CONTENT = "application/json";
    private static final String API_CLIENT_HEADER = "User-Agent";
    private static final String API_CLIENT_VALUE;
    private final String key;

    public void apply(RequestTemplate template) {
        template.query(API_KEY_PARAM, new String[]{this.key});
        template.header(ACCEPT_HEADER, new String[]{JSON_CONTENT});
        template.header(API_CLIENT_HEADER, new String[]{API_CLIENT_VALUE});
    }

    @Generated
    public ApiKeyRequestInterceptor(String key) {
        this.key = key;
    }

    static {
        String version;
        log = LoggerFactory.getLogger(ApiKeyRequestInterceptor.class);
        try {
            version = CharStreams.toString((Readable)new InputStreamReader(ApiKeyRequestInterceptor.class.getResourceAsStream("/io/ipdata/client/VERSION"))).replaceAll("\\n", "");
            version = String.format("io.ipdata.client.java.%s", version);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            version = "io.ipdata.client.java.UNKNOWN";
        }
        API_CLIENT_VALUE = version;
    }
}

