/*
 * Decompiled with CFR 0.152.
 */
package io.ipdata.client.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.CharStreams;
import feign.Response;
import feign.codec.ErrorDecoder;
import io.ipdata.client.error.RateLimitException;
import io.ipdata.client.error.RemoteIpdataException;
import io.ipdata.client.model.Error;
import java.io.IOException;
import java.net.URL;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiErrorDecoder
implements ErrorDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiErrorDecoder.class);
    private static final int RATE_LIMIT_STATUS = 403;
    private final ObjectMapper mapper;
    private final Logger logger;

    public Exception decode(String methodKey, Response response) {
        String message = null;
        try {
            int responseCode = response.status();
            URL url = new URL(response.request().url());
            this.logger.error("An error occurred during an Ipdata API call: got status '{}' for path '{}'", (Object)responseCode, (Object)url.getPath());
            message = CharStreams.toString((Readable)response.body().asReader());
            Error error = (Error)this.mapper.readValue(message, Error.class);
            if (responseCode == 403) {
                return new RateLimitException(error.getMessage(), responseCode);
            }
            return new RemoteIpdataException(error.getMessage(), response.status());
        }
        catch (IOException ioException) {
            log.error(ioException.getMessage(), (Throwable)ioException);
            return new RemoteIpdataException(message, response.status());
        }
    }

    @Generated
    public ApiErrorDecoder(ObjectMapper mapper, Logger logger) {
        this.mapper = mapper;
        this.logger = logger;
    }
}

