/*
 * Decompiled with CFR 0.152.
 */
package io.ipdata.client.service;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import feign.Client;
import feign.Feign;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.httpclient.ApacheHttpClient;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import io.ipdata.client.model.AsnModel;
import io.ipdata.client.model.Currency;
import io.ipdata.client.model.IpdataModel;
import io.ipdata.client.model.ThreatModel;
import io.ipdata.client.model.TimeZone;
import io.ipdata.client.service.ApiErrorDecoder;
import io.ipdata.client.service.ApiKeyRequestInterceptor;
import io.ipdata.client.service.CacheConfig;
import io.ipdata.client.service.CachingInternalClient;
import io.ipdata.client.service.FieldDecoder;
import io.ipdata.client.service.HashPair;
import io.ipdata.client.service.IpdataInternalClient;
import io.ipdata.client.service.IpdataInternalSingleFieldClient;
import io.ipdata.client.service.IpdataService;
import io.ipdata.client.service.IpdataServiceSupport;
import java.net.URL;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpdataServiceBuilder {
    private final URL url;
    private final String key;
    private final CacheConfig cacheConfig;
    private final Logger logger;
    private final Client httpClient;

    public IpdataService build() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        ApiKeyRequestInterceptor keyRequestInterceptor = new ApiKeyRequestInterceptor(this.key);
        Logger customLogger = this.logger == null ? LoggerFactory.getLogger(IpdataService.class) : this.logger;
        ApiErrorDecoder apiErrorDecoder = new ApiErrorDecoder(mapper, customLogger);
        final IpdataInternalClient client = (IpdataInternalClient)Feign.builder().client((Client)(this.httpClient == null ? new ApacheHttpClient() : this.httpClient)).decoder((Decoder)new JacksonDecoder(mapper)).encoder((Encoder)new JacksonEncoder(mapper)).requestInterceptor((RequestInterceptor)keyRequestInterceptor).errorDecoder((ErrorDecoder)apiErrorDecoder).target(IpdataInternalClient.class, this.url.toString());
        final IpdataInternalSingleFieldClient singleFieldClient = (IpdataInternalSingleFieldClient)Feign.builder().client((Client)(this.httpClient == null ? new ApacheHttpClient() : this.httpClient)).decoder((Decoder)new FieldDecoder(mapper)).encoder((Encoder)new JacksonEncoder(mapper)).requestInterceptor((RequestInterceptor)keyRequestInterceptor).errorDecoder((ErrorDecoder)apiErrorDecoder).target(IpdataInternalSingleFieldClient.class, this.url.toString());
        if (this.cacheConfig != null) {
            CachingInternalClient cachingInternalClient = CachingInternalClient.builder().expiry(this.cacheConfig.timeout()).unit(this.cacheConfig.unit()).maxSize(this.cacheConfig.maxSize()).ipdataCache((LoadingCache<String, IpdataModel>)CacheBuilder.newBuilder().expireAfterWrite((long)this.cacheConfig.timeout(), this.cacheConfig.unit()).maximumSize(this.cacheConfig.maxSize()).build((CacheLoader)new CacheLoader<String, IpdataModel>(){

                public IpdataModel load(String key) throws Exception {
                    return client.ipdata(key);
                }
            })).fieldsCache((LoadingCache<HashPair<String, String>, IpdataModel>)CacheBuilder.newBuilder().expireAfterWrite((long)this.cacheConfig.timeout(), this.cacheConfig.unit()).maximumSize(this.cacheConfig.maxSize()).build((CacheLoader)new CacheLoader<HashPair<String, String>, IpdataModel>(){

                public IpdataModel load(HashPair<String, String> key) throws Exception {
                    return client.getFields((String)key.key, (String)key.value);
                }
            })).asnCache((LoadingCache<String, AsnModel>)CacheBuilder.newBuilder().expireAfterWrite((long)this.cacheConfig.timeout(), this.cacheConfig.unit()).maximumSize(this.cacheConfig.maxSize()).build((CacheLoader)new CacheLoader<String, AsnModel>(){

                public AsnModel load(String key) throws Exception {
                    return singleFieldClient.asn(key);
                }
            })).tzCache((LoadingCache<String, TimeZone>)CacheBuilder.newBuilder().expireAfterWrite((long)this.cacheConfig.timeout(), this.cacheConfig.unit()).maximumSize(this.cacheConfig.maxSize()).build((CacheLoader)new CacheLoader<String, TimeZone>(){

                public TimeZone load(String key) throws Exception {
                    return singleFieldClient.timeZone(key);
                }
            })).currencyCache((LoadingCache<String, Currency>)CacheBuilder.newBuilder().expireAfterWrite((long)this.cacheConfig.timeout(), this.cacheConfig.unit()).maximumSize(this.cacheConfig.maxSize()).build((CacheLoader)new CacheLoader<String, Currency>(){

                public Currency load(String key) throws Exception {
                    return singleFieldClient.currency(key);
                }
            })).threatCache((LoadingCache<String, ThreatModel>)CacheBuilder.newBuilder().expireAfterWrite((long)this.cacheConfig.timeout(), this.cacheConfig.unit()).maximumSize(this.cacheConfig.maxSize()).build((CacheLoader)new CacheLoader<String, ThreatModel>(){

                public ThreatModel load(String key) throws Exception {
                    return singleFieldClient.threat(key);
                }
            })).ipdataInternalClient(client).ipdataInternalSingleFieldClient(singleFieldClient).build();
            return new IpdataServiceSupport(cachingInternalClient, cachingInternalClient);
        }
        return new IpdataServiceSupport(client, singleFieldClient);
    }

    @Generated
    private IpdataServiceBuilder(URL url, String key, CacheConfig cacheConfig, Logger logger, Client httpClient) {
        this.url = url;
        this.key = key;
        this.cacheConfig = cacheConfig;
        this.logger = logger;
        this.httpClient = httpClient;
    }

    @Generated
    public static IpdataServiceBuilder of(URL url, String key, CacheConfig cacheConfig, Logger logger, Client httpClient) {
        return new IpdataServiceBuilder(url, key, cacheConfig, logger, httpClient);
    }
}

