/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.amazonaws.AmazonClientException;
import com.amazonaws.util.Base64;
import com.amazonaws.util.StringUtils;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientContext {
    private static final String TAG = "ClientContext";
    static final String SHARED_PREFERENCES = "com.amazonaws.common";
    private final JSONObject json;
    private String base64String;

    public ClientContext(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context can't be null");
        }
        this.json = new JSONObject();
        try {
            this.json.put("client", (Object)ClientContext.getClientInfo(context)).put("env", (Object)ClientContext.getDeviceInfo(context));
        }
        catch (JSONException e) {
            throw new AmazonClientException("Failed to build client context", (Throwable)e);
        }
    }

    public static String getInstallationId(Context context) {
        SharedPreferences sp = context.getSharedPreferences(SHARED_PREFERENCES, 0);
        String installationId = sp.getString("installation_id", null);
        if (installationId == null) {
            installationId = UUID.randomUUID().toString();
            sp.edit().putString("installation_id", installationId).commit();
        }
        return installationId;
    }

    static JSONObject getClientInfo(Context context) throws JSONException {
        JSONObject client = new JSONObject();
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            client.put("installation_id", (Object)ClientContext.getInstallationId(context)).put("app_version_name", (Object)packageInfo.versionName).put("app_version_code", (Object)String.valueOf(packageInfo.versionCode)).put("app_package_name", (Object)packageInfo.packageName);
            CharSequence title = packageManager.getApplicationLabel(applicationInfo);
            client.put("app_title", (Object)(title == null ? "Unknown" : title.toString()));
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)TAG, (String)("Failed to load package info: " + context.getPackageName()), (Throwable)e);
        }
        return client;
    }

    static JSONObject getDeviceInfo(Context context) throws JSONException {
        JSONObject env = new JSONObject().put("platform", (Object)"Android").put("model", (Object)Build.MODEL).put("make", (Object)Build.MANUFACTURER).put("platform_version", (Object)Build.VERSION.RELEASE).put("locale", (Object)Locale.getDefault().toString());
        return env;
    }

    public void putCustomContext(Map<String, String> map) {
        this.base64String = null;
        try {
            this.json.put("custom", (Object)new JSONObject(map));
        }
        catch (JSONException e) {
            throw new AmazonClientException("Failed to add user defined context", (Throwable)e);
        }
    }

    public void putServiceContext(String service, Map<String, String> map) {
        this.base64String = null;
        try {
            if (!this.json.has("services")) {
                this.json.put("services", (Object)new JSONObject());
            }
            JSONObject services = this.json.getJSONObject("services");
            services.put(service, (Object)new JSONObject(map));
        }
        catch (JSONException e) {
            throw new AmazonClientException("Failed to add service context", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toBase64String() {
        if (this.base64String == null) {
            ClientContext clientContext = this;
            synchronized (clientContext) {
                if (this.base64String == null) {
                    this.base64String = Base64.encodeAsString((byte[])this.json.toString().getBytes(StringUtils.UTF8));
                }
            }
        }
        return this.base64String;
    }

    JSONObject getJson() {
        return this.json;
    }
}

