/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.kms;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.MasterKeyRequest;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.NoSuchMasterKeyException;
import com.amazonaws.encryptionsdk.exception.UnsupportedProviderException;
import com.amazonaws.encryptionsdk.kms.KmsMasterKey;
import com.amazonaws.encryptionsdk.kms.KmsMethods;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClient;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class KmsMasterKeyProvider
extends MasterKeyProvider<KmsMasterKey>
implements KmsMethods {
    private static final String PROVIDER_NAME = "aws-kms";
    private final List<String> keyIds_;
    private final List<String> grantTokens_;
    private final RegionalClientSupplier regionalClientSupplier_;
    private final String defaultRegion_;

    public static Builder builder() {
        return new Builder();
    }

    private KmsMasterKeyProvider(RegionalClientSupplier supplier, String defaultRegion, List<String> keyIds, List<String> grantTokens, boolean onlyOneRegion) {
        if (onlyOneRegion) {
            RegionalClientSupplier originalSupplier = supplier;
            supplier = region -> {
                if (!Objects.equals(region, defaultRegion)) {
                    return null;
                }
                return originalSupplier.getClient(region);
            };
        }
        this.regionalClientSupplier_ = supplier;
        this.defaultRegion_ = defaultRegion;
        this.keyIds_ = Collections.unmodifiableList(new ArrayList<String>(keyIds));
        this.grantTokens_ = grantTokens;
    }

    private KmsMasterKeyProvider(RegionalClientSupplier supplier, String defaultRegion, List<String> keyIds) {
        this(supplier, defaultRegion, keyIds, new ArrayList<String>(), true);
    }

    private static RegionalClientSupplier defaultProvider() {
        return KmsMasterKeyProvider.builder().clientFactory();
    }

    @Deprecated
    public KmsMasterKeyProvider() {
        this(KmsMasterKeyProvider.defaultProvider(), Regions.DEFAULT_REGION.getName(), Collections.emptyList());
    }

    @Deprecated
    public KmsMasterKeyProvider(String keyId) {
        this(KmsMasterKeyProvider.defaultProvider(), KmsMasterKeyProvider.getStartingRegion(keyId).getName(), Collections.singletonList(keyId));
    }

    @Deprecated
    public KmsMasterKeyProvider(AWSCredentials creds, String keyId) {
        this((AWSCredentialsProvider)new AWSStaticCredentialsProvider(creds), KmsMasterKeyProvider.getStartingRegion(keyId), new ClientConfiguration(), keyId);
    }

    @Deprecated
    public KmsMasterKeyProvider(AWSCredentialsProvider creds, String keyId) {
        this(creds, KmsMasterKeyProvider.getStartingRegion(keyId), new ClientConfiguration(), keyId);
    }

    @Deprecated
    public KmsMasterKeyProvider(AWSCredentials creds) {
        this((AWSCredentialsProvider)new AWSStaticCredentialsProvider(creds), Region.getRegion((Regions)Regions.DEFAULT_REGION), new ClientConfiguration(), Collections.emptyList());
    }

    @Deprecated
    public KmsMasterKeyProvider(AWSCredentialsProvider creds) {
        this(creds, Region.getRegion((Regions)Regions.DEFAULT_REGION), new ClientConfiguration(), Collections.emptyList());
    }

    public KmsMasterKeyProvider(AWSCredentialsProvider creds, Region region, ClientConfiguration clientConfiguration, String keyId) {
        this(creds, region, clientConfiguration, Collections.singletonList(keyId));
    }

    public KmsMasterKeyProvider(AWSCredentialsProvider creds, Region region, ClientConfiguration clientConfiguration, List<String> keyIds) {
        this(KmsMasterKeyProvider.builder().withClientBuilder((AWSKMSClientBuilder)((AWSKMSClientBuilder)AWSKMSClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials(creds)).clientFactory(), region.getName(), keyIds);
    }

    @Deprecated
    public KmsMasterKeyProvider(AWSKMS kms, Region region, List<String> keyIds) {
        this((String requestedRegion) -> kms, region.getName(), keyIds);
        kms.setRegion(region);
    }

    @Override
    public String getDefaultProviderId() {
        return PROVIDER_NAME;
    }

    @Override
    public KmsMasterKey getMasterKey(String provider, String keyId) throws UnsupportedProviderException, NoSuchMasterKeyException {
        if (!this.canProvide(provider)) {
            throw new UnsupportedProviderException();
        }
        String regionName = KmsMasterKeyProvider.parseRegionfromKeyArn(keyId);
        AWSKMS kms = this.regionalClientSupplier_.getClient(regionName);
        if (kms == null) {
            throw new AwsCryptoException("Can't use keys from region " + regionName);
        }
        KmsMasterKey result = KmsMasterKey.getInstance(kms, keyId, this);
        result.setGrantTokens(this.grantTokens_);
        return result;
    }

    @Override
    public List<KmsMasterKey> getMasterKeysForEncryption(MasterKeyRequest request) {
        if (this.keyIds_ == null) {
            return Collections.emptyList();
        }
        ArrayList<KmsMasterKey> result = new ArrayList<KmsMasterKey>(this.keyIds_.size());
        for (String id : this.keyIds_) {
            result.add((KmsMasterKey)this.getMasterKey(id));
        }
        return result;
    }

    @Override
    public DataKey<KmsMasterKey> decryptDataKey(CryptoAlgorithm algorithm, Collection<? extends EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext) throws AwsCryptoException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (EncryptedDataKey encryptedDataKey : encryptedDataKeys) {
            if (!this.canProvide(encryptedDataKey.getProviderId())) continue;
            try {
                String keyArn = new String(encryptedDataKey.getProviderInformation(), StandardCharsets.UTF_8);
                return ((KmsMasterKey)this.getMasterKey(keyArn)).decryptDataKey(algorithm, Collections.singletonList(encryptedDataKey), encryptionContext);
            }
            catch (Exception asex) {
                exceptions.add(asex);
            }
        }
        throw this.buildCannotDecryptDksException(exceptions);
    }

    @Override
    @Deprecated
    public void setGrantTokens(List<String> grantTokens) {
        try {
            this.grantTokens_.clear();
            this.grantTokens_.addAll(grantTokens);
        }
        catch (UnsupportedOperationException e) {
            throw this.grantTokenError();
        }
    }

    @Override
    public List<String> getGrantTokens() {
        return new ArrayList<String>(this.grantTokens_);
    }

    @Override
    @Deprecated
    public void addGrantToken(String grantToken) {
        try {
            this.grantTokens_.add(grantToken);
        }
        catch (UnsupportedOperationException e) {
            throw this.grantTokenError();
        }
    }

    private RuntimeException grantTokenError() {
        return new IllegalStateException("This master key provider is immutable. Use withGrantTokens instead.");
    }

    public KmsMasterKeyProvider withGrantTokens(List<String> grantTokens) {
        grantTokens = Collections.unmodifiableList(new ArrayList<String>(grantTokens));
        return new KmsMasterKeyProvider(this.regionalClientSupplier_, this.defaultRegion_, this.keyIds_, grantTokens, false);
    }

    public KmsMasterKeyProvider withGrantTokens(String ... grantTokens) {
        return this.withGrantTokens(Arrays.asList(grantTokens));
    }

    private static Region getStartingRegion(String keyArn) {
        String region = KmsMasterKeyProvider.parseRegionfromKeyArn(keyArn);
        if (region != null) {
            return RegionUtils.getRegion((String)region);
        }
        Region currentRegion = Regions.getCurrentRegion();
        if (currentRegion != null) {
            return currentRegion;
        }
        return Region.getRegion((Regions)Regions.DEFAULT_REGION);
    }

    private static String parseRegionfromKeyArn(String keyArn) {
        String[] parts = keyArn.split(":", 5);
        if (!parts[0].equals("arn")) {
            return null;
        }
        if (!parts[2].equals("kms")) {
            return null;
        }
        return parts[3];
    }

    public static final class Builder
    implements Cloneable {
        private String defaultRegion_ = null;
        private RegionalClientSupplier regionalClientSupplier_ = null;
        private AWSKMSClientBuilder templateBuilder_ = null;
        private List<String> keyIds_ = new ArrayList<String>();

        public Builder clone() {
            try {
                Builder cloned = (Builder)super.clone();
                if (this.templateBuilder_ != null) {
                    cloned.templateBuilder_ = this.cloneClientBuilder(this.templateBuilder_);
                }
                cloned.keyIds_ = new ArrayList<String>(this.keyIds_);
                return cloned;
            }
            catch (CloneNotSupportedException e) {
                throw new Error("Impossible: CloneNotSupportedException", e);
            }
        }

        public Builder withKeysForEncryption(String ... keyIds) {
            this.keyIds_.addAll(Arrays.asList(keyIds));
            return this;
        }

        public Builder withKeysForEncryption(List<String> keyIds) {
            this.keyIds_.addAll(keyIds);
            return this;
        }

        public Builder withDefaultRegion(String defaultRegion) {
            this.defaultRegion_ = defaultRegion;
            return this;
        }

        public Builder withCustomClientFactory(RegionalClientSupplier regionalClientSupplier) {
            if (this.templateBuilder_ != null) {
                throw this.clientSupplierComboException();
            }
            this.regionalClientSupplier_ = regionalClientSupplier;
            return this;
        }

        private RuntimeException clientSupplierComboException() {
            return new IllegalStateException("withCustomClientFactory cannot be used in conjunction with withCredentials or withClientBuilder");
        }

        public Builder withCredentials(AWSCredentialsProvider credentialsProvider) {
            if (this.regionalClientSupplier_ != null) {
                throw this.clientSupplierComboException();
            }
            if (this.templateBuilder_ == null) {
                this.templateBuilder_ = AWSKMSClientBuilder.standard();
            }
            this.templateBuilder_.setCredentials(credentialsProvider);
            return this;
        }

        public Builder withCredentials(AWSCredentials credentials) {
            return this.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(credentials));
        }

        public Builder withClientBuilder(AWSKMSClientBuilder builder) {
            AWSKMSClientBuilder newBuilder;
            if (this.regionalClientSupplier_ != null) {
                throw this.clientSupplierComboException();
            }
            this.templateBuilder_ = newBuilder = this.cloneClientBuilder(builder);
            return this;
        }

        private AWSKMSClientBuilder cloneClientBuilder(AWSKMSClientBuilder builder) {
            if (builder.getEndpoint() != null) {
                throw new IllegalArgumentException("Setting endpoint configuration is not compatible with passing a builder to the KmsMasterKeyProvider. Use withCustomClientFactory instead.");
            }
            AWSKMSClientBuilder newBuilder = AWSKMSClient.builder();
            newBuilder.setClientConfiguration(builder.getClientConfiguration());
            newBuilder.setCredentials(builder.getCredentials());
            newBuilder.setEndpointConfiguration(builder.getEndpoint());
            newBuilder.setMetricsCollector(builder.getMetricsCollector());
            if (builder.getRequestHandlers() != null) {
                newBuilder.setRequestHandlers(builder.getRequestHandlers().toArray(new RequestHandler2[0]));
            }
            return newBuilder;
        }

        public KmsMasterKeyProvider build() {
            if (this.defaultRegion_ == null) {
                for (String keyId : this.keyIds_) {
                    if (KmsMasterKeyProvider.parseRegionfromKeyArn(keyId) != null) continue;
                    throw new AwsCryptoException("Can't use non-ARN key identifiers or aliases when no default region is set");
                }
            }
            RegionalClientSupplier supplier = this.clientFactory();
            return new KmsMasterKeyProvider(supplier, this.defaultRegion_, this.keyIds_, Collections.emptyList(), false);
        }

        private RegionalClientSupplier clientFactory() {
            if (this.regionalClientSupplier_ != null) {
                return this.regionalClientSupplier_;
            }
            AWSKMSClientBuilder builder = this.templateBuilder_ != null ? this.cloneClientBuilder(this.templateBuilder_) : AWSKMSClientBuilder.standard();
            ConcurrentHashMap clientCache = new ConcurrentHashMap();
            return region -> clientCache.computeIfAbsent(region, region2 -> (AWSKMS)((AWSKMSClientBuilder)this.cloneClientBuilder(builder).withRegion(region2)).build());
        }
    }

    @FunctionalInterface
    public static interface RegionalClientSupplier {
        public AWSKMS getClient(String var1);
    }
}

