/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.codebuild.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.codebuild.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * TestCase JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class TestCaseJsonUnmarshaller implements Unmarshaller<TestCase, JsonUnmarshallerContext> {

    public TestCase unmarshall(JsonUnmarshallerContext context) throws Exception {
        TestCase testCase = new TestCase();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("reportArn", targetDepth)) {
                    context.nextToken();
                    testCase.setReportArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("testRawDataPath", targetDepth)) {
                    context.nextToken();
                    testCase.setTestRawDataPath(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("prefix", targetDepth)) {
                    context.nextToken();
                    testCase.setPrefix(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    testCase.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    testCase.setStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("durationInNanoSeconds", targetDepth)) {
                    context.nextToken();
                    testCase.setDurationInNanoSeconds(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("message", targetDepth)) {
                    context.nextToken();
                    testCase.setMessage(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("expired", targetDepth)) {
                    context.nextToken();
                    testCase.setExpired(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return testCase;
    }

    private static TestCaseJsonUnmarshaller instance;

    public static TestCaseJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new TestCaseJsonUnmarshaller();
        return instance;
    }
}
