/*
 * Decompiled with CFR 0.152.
 */
package com.askfast.askfastapi;

import com.askfast.model.Adapter;
import com.askfast.model.DDRRecord;
import com.askfast.model.Dialog;
import com.askfast.model.DialogRequest;
import com.askfast.util.AskFastRestService;
import com.askfast.util.JacksonConverter;
import com.squareup.okhttp.OkHttpClient;
import java.util.List;
import java.util.Set;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.converter.Converter;

public class AskFastRestClient {
    public static final String ASKFAST_REST_API = "http://api.ask-fast.com";
    public static final String ASKFAST_KEYSERVER = "http://live.ask-fast.com/keyserver/token";
    private String accountId = null;
    private String refreshToken = null;
    private String accessToken = null;

    public AskFastRestClient(String accountId) {
        this(accountId, null);
    }

    public AskFastRestClient(String accountId, String refreshToken) {
        this(accountId, refreshToken, null);
    }

    public AskFastRestClient(String accountId, String refreshToken, String accessToken) {
        this.accountId = accountId;
        this.refreshToken = refreshToken;
        this.accessToken = accessToken;
    }

    public String startPhoneDialog(String fromAddress, String toAddress, String url) {
        AskFastRestService service = this.getRestService();
        return service.startDialog(new DialogRequest(fromAddress, toAddress, url));
    }

    public Set<Adapter> getAdapters(String type) {
        AskFastRestService service = this.getRestService();
        return service.getAdapters(type);
    }

    public void buyAdapter(String adapterId) {
        AskFastRestService service = this.getRestService();
        service.buyAdapter(adapterId);
    }

    public void removeAdapter(String adapterId) {
        AskFastRestService service = this.getRestService();
        service.removeAdapter(adapterId);
    }

    public Set<Adapter> getFreeAdapters(String adapterType, String address) {
        AskFastRestService service = this.getRestService();
        return service.getFreeAdapters(adapterType, address);
    }

    public Dialog createDialog(Dialog dialog) {
        AskFastRestService service = this.getRestService();
        return service.createDialog(dialog);
    }

    public Set<Dialog> getDialogs() {
        AskFastRestService service = this.getRestService();
        return service.getDialogs();
    }

    public Dialog getDialog(String dialogId) {
        AskFastRestService service = this.getRestService();
        return service.getDialog(dialogId);
    }

    public Dialog updateDialog(String dialogId, Dialog dialog) {
        AskFastRestService service = this.getRestService();
        return service.updateDialog(dialogId, dialog);
    }

    public void removeDialog(String dialogId) {
        AskFastRestService service = this.getRestService();
        service.removeDialog(dialogId);
    }

    public List<DDRRecord> getDDRRecords(String adapterId, String fromAddress, String typeId, String status, Long startTime, Long endTime, String delimitedSessionKeys, Integer offset, Integer limit, Boolean shouldGenerateCosts, Boolean shouldIncludeServiceCosts) {
        AskFastRestService service = this.getRestService();
        return service.getDDRRecords(adapterId, fromAddress, typeId, status, startTime, endTime, delimitedSessionKeys, offset, limit, shouldGenerateCosts, shouldIncludeServiceCosts);
    }

    private RestAdapter getRestAdapter() {
        return new RestAdapter.Builder().setRequestInterceptor(new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                try {
                    String token = AskFastRestClient.this.getAccessToken();
                    request.addHeader("Authorization", "Bearer " + token);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).setEndpoint(ASKFAST_REST_API).setConverter((Converter)new JacksonConverter()).setClient((Client)new OkClient(new OkHttpClient())).build();
    }

    private AskFastRestService getRestService() {
        RestAdapter adapter = this.getRestAdapter();
        return (AskFastRestService)adapter.create(AskFastRestService.class);
    }

    public String getAccessToken() throws Exception {
        if (this.accessToken != null) {
            return this.accessToken;
        }
        return this.refreshAccessToken();
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    private String refreshAccessToken() throws Exception {
        if (this.accountId == null) {
            throw new Exception("AccountID isn't set.");
        }
        if (this.refreshToken == null) {
            throw new Exception("Refresh Token isn't set.");
        }
        OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
        OAuthClientRequest request = OAuthClientRequest.tokenLocation((String)ASKFAST_KEYSERVER).setGrantType(GrantType.REFRESH_TOKEN).setClientId(this.accountId).setClientSecret("blabla").setRefreshToken(this.refreshToken).buildQueryMessage();
        OAuthJSONAccessTokenResponse response = oAuthClient.accessToken(request);
        if (response.getAccessToken() != null) {
            this.accessToken = response.getAccessToken();
        }
        return this.accessToken;
    }
}

