/*
 * Decompiled with CFR 0.152.
 */
package com.askfast.model;

import com.askfast.model.AdapterType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DialogRequest {
    private String address;
    private Collection<String> addressList;
    private Map<String, String> addressMap;
    private Map<String, String> addressCcMap;
    private Map<String, String> addressBccMap;
    private String senderName;
    private String subject;
    private String url;
    private AdapterType adapterType;
    private String adapterID;

    public DialogRequest(Map<String, String> addressMap, Map<String, String> addressCcMap, Map<String, String> addressBccMap, String adapterID, String senderName, String subject, String url) {
        this.addressMap = addressMap;
        this.addressCcMap = addressCcMap;
        this.addressBccMap = addressBccMap;
        this.adapterID = adapterID;
        this.senderName = senderName;
        this.subject = subject;
        this.url = url;
    }

    public DialogRequest(String address, String adapterId, String url) {
        this.address = address;
        this.adapterID = adapterId;
        this.url = url;
    }

    public DialogRequest(String address, AdapterType adapterType, String url) {
        this.address = address;
        this.adapterType = adapterType;
        this.url = url;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Collection<String> getAddressList() {
        return this.addressList;
    }

    public void setAddressList(Collection<String> addressList) {
        this.addressList = addressList;
    }

    public Map<String, String> getAddressMap() {
        return this.addressMap;
    }

    public void setAddressMap(Map<String, String> addressMap) {
        this.addressMap = addressMap;
    }

    public Map<String, String> getAddressCcMap() {
        return this.addressCcMap;
    }

    public void setAddressCcMap(Map<String, String> addressCcMap) {
        this.addressCcMap = addressCcMap;
    }

    public Map<String, String> getAddressBccMap() {
        return this.addressBccMap;
    }

    public void setAddressBccMap(Map<String, String> addressBccMap) {
        this.addressBccMap = addressBccMap;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public AdapterType getAdapterType() {
        return this.adapterType;
    }

    public void setAdapterType(AdapterType adapterType) {
        this.adapterType = adapterType;
    }

    public String getAdapterID() {
        return this.adapterID;
    }

    public void setAdapterID(String adapterID) {
        this.adapterID = adapterID;
    }

    @JsonIgnore
    public HashMap<String, String> getAllAddresses() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.address != null) {
            result.put(this.address, "");
        }
        if (this.addressList != null && !this.addressList.isEmpty()) {
            for (String address : this.addressList) {
                result.put(address, "");
            }
        }
        if (this.addressMap != null && !this.addressMap.isEmpty()) {
            result.putAll(this.addressMap);
        }
        if (this.getAddressCcMap() != null && !this.addressCcMap.isEmpty()) {
            result.putAll(this.addressCcMap);
        }
        if (this.getAddressBccMap() != null && !this.addressBccMap.isEmpty()) {
            result.putAll(this.addressBccMap);
        }
        return result;
    }

    @JsonIgnore
    public boolean isValidRequest() {
        return !this.getAllAddresses().isEmpty() && this.url != null && (this.adapterID != null || this.adapterType != null);
    }
}

